package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait RequiresRecreation {
  def unwrap
      : software.amazon.awssdk.services.servicecatalog.model.RequiresRecreation
}
object RequiresRecreation {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.RequiresRecreation
  ): zio.aws.servicecatalog.model.RequiresRecreation = value match {
    case software.amazon.awssdk.services.servicecatalog.model.RequiresRecreation.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicecatalog.model.RequiresRecreation.NEVER =>
      val r = NEVER
      r
    case software.amazon.awssdk.services.servicecatalog.model.RequiresRecreation.CONDITIONALLY =>
      val r = CONDITIONALLY
      r
    case software.amazon.awssdk.services.servicecatalog.model.RequiresRecreation.ALWAYS =>
      val r = ALWAYS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicecatalog.model.RequiresRecreation {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.RequiresRecreation =
      software.amazon.awssdk.services.servicecatalog.model.RequiresRecreation.UNKNOWN_TO_SDK_VERSION
  }
  case object NEVER extends zio.aws.servicecatalog.model.RequiresRecreation {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.RequiresRecreation =
      software.amazon.awssdk.services.servicecatalog.model.RequiresRecreation.NEVER
  }
  case object CONDITIONALLY
      extends zio.aws.servicecatalog.model.RequiresRecreation {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.RequiresRecreation =
      software.amazon.awssdk.services.servicecatalog.model.RequiresRecreation.CONDITIONALLY
  }
  case object ALWAYS extends zio.aws.servicecatalog.model.RequiresRecreation {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.RequiresRecreation =
      software.amazon.awssdk.services.servicecatalog.model.RequiresRecreation.ALWAYS
  }
}
