package zio.aws.servicecatalog.model
import zio.aws.servicecatalog.model.primitives.{
  RoleArn,
  ProvisionedProductId,
  LastRequestId,
  ProvisionedProductType,
  IdempotencyToken,
  ProvisionedProductNameOrArn,
  CreatedTime,
  ProvisionedProductStatusMessage,
  Id
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ProvisionedProductDetail(
    name: Optional[ProvisionedProductNameOrArn] = Optional.Absent,
    arn: Optional[ProvisionedProductNameOrArn] = Optional.Absent,
    `type`: Optional[ProvisionedProductType] = Optional.Absent,
    id: Optional[ProvisionedProductId] = Optional.Absent,
    status: Optional[zio.aws.servicecatalog.model.ProvisionedProductStatus] =
      Optional.Absent,
    statusMessage: Optional[ProvisionedProductStatusMessage] = Optional.Absent,
    createdTime: Optional[CreatedTime] = Optional.Absent,
    idempotencyToken: Optional[IdempotencyToken] = Optional.Absent,
    lastRecordId: Optional[LastRequestId] = Optional.Absent,
    lastProvisioningRecordId: Optional[Id] = Optional.Absent,
    lastSuccessfulProvisioningRecordId: Optional[Id] = Optional.Absent,
    productId: Optional[Id] = Optional.Absent,
    provisioningArtifactId: Optional[Id] = Optional.Absent,
    launchRoleArn: Optional[RoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductDetail = {
    import ProvisionedProductDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductDetail
      .builder()
      .optionallyWith(
        name.map(value =>
          ProvisionedProductNameOrArn.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        arn.map(value =>
          ProvisionedProductNameOrArn.unwrap(value): java.lang.String
        )
      )(_.arn)
      .optionallyWith(
        `type`.map(value =>
          ProvisionedProductType.unwrap(value): java.lang.String
        )
      )(_.`type`)
      .optionallyWith(
        id.map(value => ProvisionedProductId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          ProvisionedProductStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        createdTime.map(value => CreatedTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        idempotencyToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.idempotencyToken)
      .optionallyWith(
        lastRecordId.map(value => LastRequestId.unwrap(value): java.lang.String)
      )(_.lastRecordId)
      .optionallyWith(
        lastProvisioningRecordId.map(value =>
          Id.unwrap(value): java.lang.String
        )
      )(_.lastProvisioningRecordId)
      .optionallyWith(
        lastSuccessfulProvisioningRecordId.map(value =>
          Id.unwrap(value): java.lang.String
        )
      )(_.lastSuccessfulProvisioningRecordId)
      .optionallyWith(
        productId.map(value => Id.unwrap(value): java.lang.String)
      )(_.productId)
      .optionallyWith(
        provisioningArtifactId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisioningArtifactId)
      .optionallyWith(
        launchRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.launchRoleArn)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ProvisionedProductDetail.ReadOnly =
    zio.aws.servicecatalog.model.ProvisionedProductDetail.wrap(buildAwsValue())
}
object ProvisionedProductDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ProvisionedProductDetail =
      zio.aws.servicecatalog.model.ProvisionedProductDetail(
        name.map(value => value),
        arn.map(value => value),
        `type`.map(value => value),
        id.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        createdTime.map(value => value),
        idempotencyToken.map(value => value),
        lastRecordId.map(value => value),
        lastProvisioningRecordId.map(value => value),
        lastSuccessfulProvisioningRecordId.map(value => value),
        productId.map(value => value),
        provisioningArtifactId.map(value => value),
        launchRoleArn.map(value => value)
      )
    def name: Optional[ProvisionedProductNameOrArn]
    def arn: Optional[ProvisionedProductNameOrArn]
    def `type`: Optional[ProvisionedProductType]
    def id: Optional[ProvisionedProductId]
    def status: Optional[zio.aws.servicecatalog.model.ProvisionedProductStatus]
    def statusMessage: Optional[ProvisionedProductStatusMessage]
    def createdTime: Optional[CreatedTime]
    def idempotencyToken: Optional[IdempotencyToken]
    def lastRecordId: Optional[LastRequestId]
    def lastProvisioningRecordId: Optional[Id]
    def lastSuccessfulProvisioningRecordId: Optional[Id]
    def productId: Optional[Id]
    def provisioningArtifactId: Optional[Id]
    def launchRoleArn: Optional[RoleArn]
    def getName: ZIO[Any, AwsError, ProvisionedProductNameOrArn] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, ProvisionedProductNameOrArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getType: ZIO[Any, AwsError, ProvisionedProductType] =
      AwsError.unwrapOptionField("type", `type`)
    def getId: ZIO[Any, AwsError, ProvisionedProductId] =
      AwsError.unwrapOptionField("id", id)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProvisionedProductStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, ProvisionedProductStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getCreatedTime: ZIO[Any, AwsError, CreatedTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getIdempotencyToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("idempotencyToken", idempotencyToken)
    def getLastRecordId: ZIO[Any, AwsError, LastRequestId] =
      AwsError.unwrapOptionField("lastRecordId", lastRecordId)
    def getLastProvisioningRecordId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("lastProvisioningRecordId", lastProvisioningRecordId)
    def getLastSuccessfulProvisioningRecordId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField(
        "lastSuccessfulProvisioningRecordId",
        lastSuccessfulProvisioningRecordId
      )
    def getProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("productId", productId)
    def getProvisioningArtifactId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("provisioningArtifactId", provisioningArtifactId)
    def getLaunchRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("launchRoleArn", launchRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductDetail
  ) extends zio.aws.servicecatalog.model.ProvisionedProductDetail.ReadOnly {
    override val name: Optional[ProvisionedProductNameOrArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisionedProductNameOrArn(value)
        )
    override val arn: Optional[ProvisionedProductNameOrArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.arn())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisionedProductNameOrArn(value)
        )
    override val `type`: Optional[ProvisionedProductType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.ProvisionedProductType(value)
        )
    override val id: Optional[ProvisionedProductId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProvisionedProductId(value)
      )
    override val status
        : Optional[zio.aws.servicecatalog.model.ProvisionedProductStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.servicecatalog.model.ProvisionedProductStatus.wrap(value)
        )
    override val statusMessage: Optional[ProvisionedProductStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisionedProductStatusMessage(value)
        )
    override val createdTime: Optional[CreatedTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.servicecatalog.model.primitives.CreatedTime(value))
    override val idempotencyToken: Optional[IdempotencyToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.idempotencyToken())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.IdempotencyToken(value)
        )
    override val lastRecordId: Optional[LastRequestId] = zio.aws.core.internal
      .optionalFromNullable(impl.lastRecordId())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.LastRequestId(value)
      )
    override val lastProvisioningRecordId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.lastProvisioningRecordId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val lastSuccessfulProvisioningRecordId: Optional[Id] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastSuccessfulProvisioningRecordId())
        .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val productId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.productId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val provisioningArtifactId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningArtifactId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val launchRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.launchRoleArn())
      .map(value => zio.aws.servicecatalog.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductDetail
  ): zio.aws.servicecatalog.model.ProvisionedProductDetail.ReadOnly =
    new Wrapper(impl)
}
