package zio.aws.servicecatalog.model
import zio.aws.servicecatalog.model.primitives.{
  UserArn,
  ProvisioningArtifactName,
  PhysicalId,
  ProvisionedProductType,
  ProductViewName,
  UserArnSession,
  IdempotencyToken,
  ProvisionedProductNameOrArn,
  CreatedTime,
  ProvisionedProductStatusMessage,
  Id
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ProvisionedProductAttribute(
    name: Optional[ProvisionedProductNameOrArn] = Optional.Absent,
    arn: Optional[ProvisionedProductNameOrArn] = Optional.Absent,
    `type`: Optional[ProvisionedProductType] = Optional.Absent,
    id: Optional[Id] = Optional.Absent,
    status: Optional[zio.aws.servicecatalog.model.ProvisionedProductStatus] =
      Optional.Absent,
    statusMessage: Optional[ProvisionedProductStatusMessage] = Optional.Absent,
    createdTime: Optional[CreatedTime] = Optional.Absent,
    idempotencyToken: Optional[IdempotencyToken] = Optional.Absent,
    lastRecordId: Optional[Id] = Optional.Absent,
    lastProvisioningRecordId: Optional[Id] = Optional.Absent,
    lastSuccessfulProvisioningRecordId: Optional[Id] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.servicecatalog.model.Tag]] =
      Optional.Absent,
    physicalId: Optional[PhysicalId] = Optional.Absent,
    productId: Optional[Id] = Optional.Absent,
    productName: Optional[ProductViewName] = Optional.Absent,
    provisioningArtifactId: Optional[Id] = Optional.Absent,
    provisioningArtifactName: Optional[ProvisioningArtifactName] =
      Optional.Absent,
    userArn: Optional[UserArn] = Optional.Absent,
    userArnSession: Optional[UserArnSession] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductAttribute = {
    import ProvisionedProductAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductAttribute
      .builder()
      .optionallyWith(
        name.map(value =>
          ProvisionedProductNameOrArn.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        arn.map(value =>
          ProvisionedProductNameOrArn.unwrap(value): java.lang.String
        )
      )(_.arn)
      .optionallyWith(
        `type`.map(value =>
          ProvisionedProductType.unwrap(value): java.lang.String
        )
      )(_.`type`)
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          ProvisionedProductStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        createdTime.map(value => CreatedTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        idempotencyToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.idempotencyToken)
      .optionallyWith(
        lastRecordId.map(value => Id.unwrap(value): java.lang.String)
      )(_.lastRecordId)
      .optionallyWith(
        lastProvisioningRecordId.map(value =>
          Id.unwrap(value): java.lang.String
        )
      )(_.lastProvisioningRecordId)
      .optionallyWith(
        lastSuccessfulProvisioningRecordId.map(value =>
          Id.unwrap(value): java.lang.String
        )
      )(_.lastSuccessfulProvisioningRecordId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        physicalId.map(value => PhysicalId.unwrap(value): java.lang.String)
      )(_.physicalId)
      .optionallyWith(
        productId.map(value => Id.unwrap(value): java.lang.String)
      )(_.productId)
      .optionallyWith(
        productName.map(value =>
          ProductViewName.unwrap(value): java.lang.String
        )
      )(_.productName)
      .optionallyWith(
        provisioningArtifactId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisioningArtifactId)
      .optionallyWith(
        provisioningArtifactName.map(value =>
          ProvisioningArtifactName.unwrap(value): java.lang.String
        )
      )(_.provisioningArtifactName)
      .optionallyWith(
        userArn.map(value => UserArn.unwrap(value): java.lang.String)
      )(_.userArn)
      .optionallyWith(
        userArnSession.map(value =>
          UserArnSession.unwrap(value): java.lang.String
        )
      )(_.userArnSession)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ProvisionedProductAttribute.ReadOnly =
    zio.aws.servicecatalog.model.ProvisionedProductAttribute
      .wrap(buildAwsValue())
}
object ProvisionedProductAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ProvisionedProductAttribute =
      zio.aws.servicecatalog.model.ProvisionedProductAttribute(
        name.map(value => value),
        arn.map(value => value),
        `type`.map(value => value),
        id.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        createdTime.map(value => value),
        idempotencyToken.map(value => value),
        lastRecordId.map(value => value),
        lastProvisioningRecordId.map(value => value),
        lastSuccessfulProvisioningRecordId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        physicalId.map(value => value),
        productId.map(value => value),
        productName.map(value => value),
        provisioningArtifactId.map(value => value),
        provisioningArtifactName.map(value => value),
        userArn.map(value => value),
        userArnSession.map(value => value)
      )
    def name: Optional[ProvisionedProductNameOrArn]
    def arn: Optional[ProvisionedProductNameOrArn]
    def `type`: Optional[ProvisionedProductType]
    def id: Optional[Id]
    def status: Optional[zio.aws.servicecatalog.model.ProvisionedProductStatus]
    def statusMessage: Optional[ProvisionedProductStatusMessage]
    def createdTime: Optional[CreatedTime]
    def idempotencyToken: Optional[IdempotencyToken]
    def lastRecordId: Optional[Id]
    def lastProvisioningRecordId: Optional[Id]
    def lastSuccessfulProvisioningRecordId: Optional[Id]
    def tags: Optional[List[zio.aws.servicecatalog.model.Tag.ReadOnly]]
    def physicalId: Optional[PhysicalId]
    def productId: Optional[Id]
    def productName: Optional[ProductViewName]
    def provisioningArtifactId: Optional[Id]
    def provisioningArtifactName: Optional[ProvisioningArtifactName]
    def userArn: Optional[UserArn]
    def userArnSession: Optional[UserArnSession]
    def getName: ZIO[Any, AwsError, ProvisionedProductNameOrArn] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, ProvisionedProductNameOrArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getType: ZIO[Any, AwsError, ProvisionedProductType] =
      AwsError.unwrapOptionField("type", `type`)
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProvisionedProductStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, ProvisionedProductStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getCreatedTime: ZIO[Any, AwsError, CreatedTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getIdempotencyToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("idempotencyToken", idempotencyToken)
    def getLastRecordId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("lastRecordId", lastRecordId)
    def getLastProvisioningRecordId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("lastProvisioningRecordId", lastProvisioningRecordId)
    def getLastSuccessfulProvisioningRecordId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField(
        "lastSuccessfulProvisioningRecordId",
        lastSuccessfulProvisioningRecordId
      )
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPhysicalId: ZIO[Any, AwsError, PhysicalId] =
      AwsError.unwrapOptionField("physicalId", physicalId)
    def getProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("productId", productId)
    def getProductName: ZIO[Any, AwsError, ProductViewName] =
      AwsError.unwrapOptionField("productName", productName)
    def getProvisioningArtifactId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("provisioningArtifactId", provisioningArtifactId)
    def getProvisioningArtifactName
        : ZIO[Any, AwsError, ProvisioningArtifactName] = AwsError
      .unwrapOptionField("provisioningArtifactName", provisioningArtifactName)
    def getUserArn: ZIO[Any, AwsError, UserArn] =
      AwsError.unwrapOptionField("userArn", userArn)
    def getUserArnSession: ZIO[Any, AwsError, UserArnSession] =
      AwsError.unwrapOptionField("userArnSession", userArnSession)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductAttribute
  ) extends zio.aws.servicecatalog.model.ProvisionedProductAttribute.ReadOnly {
    override val name: Optional[ProvisionedProductNameOrArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisionedProductNameOrArn(value)
        )
    override val arn: Optional[ProvisionedProductNameOrArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.arn())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisionedProductNameOrArn(value)
        )
    override val `type`: Optional[ProvisionedProductType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.ProvisionedProductType(value)
        )
    override val id: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val status
        : Optional[zio.aws.servicecatalog.model.ProvisionedProductStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.servicecatalog.model.ProvisionedProductStatus.wrap(value)
        )
    override val statusMessage: Optional[ProvisionedProductStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisionedProductStatusMessage(value)
        )
    override val createdTime: Optional[CreatedTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.servicecatalog.model.primitives.CreatedTime(value))
    override val idempotencyToken: Optional[IdempotencyToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.idempotencyToken())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.IdempotencyToken(value)
        )
    override val lastRecordId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.lastRecordId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val lastProvisioningRecordId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.lastProvisioningRecordId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val lastSuccessfulProvisioningRecordId: Optional[Id] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastSuccessfulProvisioningRecordId())
        .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val tags
        : Optional[List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.Tag.wrap(item)
          }.toList
        )
    override val physicalId: Optional[PhysicalId] = zio.aws.core.internal
      .optionalFromNullable(impl.physicalId())
      .map(value => zio.aws.servicecatalog.model.primitives.PhysicalId(value))
    override val productId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.productId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val productName: Optional[ProductViewName] = zio.aws.core.internal
      .optionalFromNullable(impl.productName())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProductViewName(value)
      )
    override val provisioningArtifactId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningArtifactId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val provisioningArtifactName: Optional[ProvisioningArtifactName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisioningArtifactName())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisioningArtifactName(value)
        )
    override val userArn: Optional[UserArn] = zio.aws.core.internal
      .optionalFromNullable(impl.userArn())
      .map(value => zio.aws.servicecatalog.model.primitives.UserArn(value))
    override val userArnSession: Optional[UserArnSession] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userArnSession())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.UserArnSession(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductAttribute
  ): zio.aws.servicecatalog.model.ProvisionedProductAttribute.ReadOnly =
    new Wrapper(impl)
}
