package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeTagOptionResponse(
    tagOptionDetail: Optional[zio.aws.servicecatalog.model.TagOptionDetail] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribeTagOptionResponse = {
    import DescribeTagOptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribeTagOptionResponse
      .builder()
      .optionallyWith(tagOptionDetail.map(value => value.buildAwsValue()))(
        _.tagOptionDetail
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribeTagOptionResponse.ReadOnly =
    zio.aws.servicecatalog.model.DescribeTagOptionResponse.wrap(buildAwsValue())
}
object DescribeTagOptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribeTagOptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.DescribeTagOptionResponse =
      zio.aws.servicecatalog.model.DescribeTagOptionResponse(
        tagOptionDetail.map(value => value.asEditable)
      )
    def tagOptionDetail
        : Optional[zio.aws.servicecatalog.model.TagOptionDetail.ReadOnly]
    def getTagOptionDetail: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.TagOptionDetail.ReadOnly
    ] = AwsError.unwrapOptionField("tagOptionDetail", tagOptionDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeTagOptionResponse
  ) extends zio.aws.servicecatalog.model.DescribeTagOptionResponse.ReadOnly {
    override val tagOptionDetail
        : Optional[zio.aws.servicecatalog.model.TagOptionDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagOptionDetail())
        .map(value => zio.aws.servicecatalog.model.TagOptionDetail.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeTagOptionResponse
  ): zio.aws.servicecatalog.model.DescribeTagOptionResponse.ReadOnly =
    new Wrapper(impl)
}
