package zio.aws.servicecatalog.model
import zio.aws.servicecatalog.model.primitives.{
  ResourceDetailDescription,
  ResourceDetailCreatedTime,
  ResourceDetailName,
  ResourceDetailARN,
  ResourceDetailId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ResourceDetail(
    id: Optional[ResourceDetailId] = Optional.Absent,
    arn: Optional[ResourceDetailARN] = Optional.Absent,
    name: Optional[ResourceDetailName] = Optional.Absent,
    description: Optional[ResourceDetailDescription] = Optional.Absent,
    createdTime: Optional[ResourceDetailCreatedTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ResourceDetail = {
    import ResourceDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ResourceDetail
      .builder()
      .optionallyWith(
        id.map(value => ResourceDetailId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        arn.map(value => ResourceDetailARN.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => ResourceDetailName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ResourceDetailDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        createdTime.map(value =>
          ResourceDetailCreatedTime.unwrap(value): Instant
        )
      )(_.createdTime)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.ResourceDetail.ReadOnly =
    zio.aws.servicecatalog.model.ResourceDetail.wrap(buildAwsValue())
}
object ResourceDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ResourceDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ResourceDetail =
      zio.aws.servicecatalog.model.ResourceDetail(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        createdTime.map(value => value)
      )
    def id: Optional[ResourceDetailId]
    def arn: Optional[ResourceDetailARN]
    def name: Optional[ResourceDetailName]
    def description: Optional[ResourceDetailDescription]
    def createdTime: Optional[ResourceDetailCreatedTime]
    def getId: ZIO[Any, AwsError, ResourceDetailId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ResourceDetailARN] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ResourceDetailName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ResourceDetailDescription] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedTime: ZIO[Any, AwsError, ResourceDetailCreatedTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ResourceDetail
  ) extends zio.aws.servicecatalog.model.ResourceDetail.ReadOnly {
    override val id: Optional[ResourceDetailId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ResourceDetailId(value)
      )
    override val arn: Optional[ResourceDetailARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ResourceDetailARN(value)
      )
    override val name: Optional[ResourceDetailName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ResourceDetailName(value)
      )
    override val description: Optional[ResourceDetailDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ResourceDetailDescription(value)
        )
    override val createdTime: Optional[ResourceDetailCreatedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTime())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ResourceDetailCreatedTime(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ResourceDetail
  ): zio.aws.servicecatalog.model.ResourceDetail.ReadOnly = new Wrapper(impl)
}
