package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{RecordTagValue, RecordTagKey}
import scala.jdk.CollectionConverters._
final case class RecordTag(
    key: Optional[RecordTagKey] = Optional.Absent,
    value: Optional[RecordTagValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.RecordTag = {
    import RecordTag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.RecordTag
      .builder()
      .optionallyWith(
        key.map(value => RecordTagKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        value.map(value => RecordTagValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.RecordTag.ReadOnly =
    zio.aws.servicecatalog.model.RecordTag.wrap(buildAwsValue())
}
object RecordTag {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.RecordTag
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.RecordTag =
      zio.aws.servicecatalog.model
        .RecordTag(key.map(value => value), value.map(value => value))
    def key: Optional[RecordTagKey]
    def value: Optional[RecordTagValue]
    def getKey: ZIO[Any, AwsError, RecordTagKey] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, RecordTagValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.RecordTag
  ) extends zio.aws.servicecatalog.model.RecordTag.ReadOnly {
    override val key: Optional[RecordTagKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.servicecatalog.model.primitives.RecordTagKey(value))
    override val value: Optional[RecordTagValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.RecordTagValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.RecordTag
  ): zio.aws.servicecatalog.model.RecordTag.ReadOnly = new Wrapper(impl)
}
