package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  DisableTemplateValidation,
  ProvisioningArtifactName,
  ProvisioningArtifactInfoValue,
  ProvisioningArtifactInfoKey,
  ProvisioningArtifactDescription
}
import scala.jdk.CollectionConverters._
final case class ProvisioningArtifactProperties(
    name: Optional[ProvisioningArtifactName] = Optional.Absent,
    description: Optional[ProvisioningArtifactDescription] = Optional.Absent,
    info: Map[ProvisioningArtifactInfoKey, ProvisioningArtifactInfoValue],
    `type`: Optional[zio.aws.servicecatalog.model.ProvisioningArtifactType] =
      Optional.Absent,
    disableTemplateValidation: Optional[DisableTemplateValidation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactProperties = {
    import ProvisioningArtifactProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactProperties
      .builder()
      .optionallyWith(
        name.map(value =>
          ProvisioningArtifactName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ProvisioningArtifactDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .info(
        info
          .map({ case (key, value) =>
            (ProvisioningArtifactInfoKey.unwrap(
              key
            ): java.lang.String) -> (ProvisioningArtifactInfoValue.unwrap(
              value
            ): java.lang.String)
          })
          .asJava
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        disableTemplateValidation.map(value =>
          DisableTemplateValidation.unwrap(value): java.lang.Boolean
        )
      )(_.disableTemplateValidation)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ProvisioningArtifactProperties.ReadOnly =
    zio.aws.servicecatalog.model.ProvisioningArtifactProperties
      .wrap(buildAwsValue())
}
object ProvisioningArtifactProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ProvisioningArtifactProperties =
      zio.aws.servicecatalog.model.ProvisioningArtifactProperties(
        name.map(value => value),
        description.map(value => value),
        info,
        `type`.map(value => value),
        disableTemplateValidation.map(value => value)
      )
    def name: Optional[ProvisioningArtifactName]
    def description: Optional[ProvisioningArtifactDescription]
    def info: Map[ProvisioningArtifactInfoKey, ProvisioningArtifactInfoValue]
    def `type`: Optional[zio.aws.servicecatalog.model.ProvisioningArtifactType]
    def disableTemplateValidation: Optional[DisableTemplateValidation]
    def getName: ZIO[Any, AwsError, ProvisioningArtifactName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ProvisioningArtifactDescription] =
      AwsError.unwrapOptionField("description", description)
    def getInfo: ZIO[Any, Nothing, Map[
      ProvisioningArtifactInfoKey,
      ProvisioningArtifactInfoValue
    ]] = ZIO.succeed(info)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProvisioningArtifactType
    ] = AwsError.unwrapOptionField("type", `type`)
    def getDisableTemplateValidation
        : ZIO[Any, AwsError, DisableTemplateValidation] = AwsError
      .unwrapOptionField("disableTemplateValidation", disableTemplateValidation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactProperties
  ) extends zio.aws.servicecatalog.model.ProvisioningArtifactProperties.ReadOnly {
    override val name: Optional[ProvisioningArtifactName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisioningArtifactName(value)
        )
    override val description: Optional[ProvisioningArtifactDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisioningArtifactDescription(value)
        )
    override val info
        : Map[ProvisioningArtifactInfoKey, ProvisioningArtifactInfoValue] = impl
      .info()
      .asScala
      .map({ case (key, value) =>
        zio.aws.servicecatalog.model.primitives.ProvisioningArtifactInfoKey(
          key
        ) -> zio.aws.servicecatalog.model.primitives
          .ProvisioningArtifactInfoValue(value)
      })
      .toMap
    override val `type`
        : Optional[zio.aws.servicecatalog.model.ProvisioningArtifactType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.servicecatalog.model.ProvisioningArtifactType.wrap(value)
        )
    override val disableTemplateValidation
        : Optional[DisableTemplateValidation] = zio.aws.core.internal
      .optionalFromNullable(impl.disableTemplateValidation())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.DisableTemplateValidation(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactProperties
  ): zio.aws.servicecatalog.model.ProvisioningArtifactProperties.ReadOnly =
    new Wrapper(impl)
}
