package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait ProvisionedProductPlanType {
  def unwrap: software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanType
}
object ProvisionedProductPlanType {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanType
  ): zio.aws.servicecatalog.model.ProvisionedProductPlanType = value match {
    case software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanType.CLOUDFORMATION =>
      val r = CLOUDFORMATION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicecatalog.model.ProvisionedProductPlanType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanType =
      software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanType.UNKNOWN_TO_SDK_VERSION
  }
  case object CLOUDFORMATION
      extends zio.aws.servicecatalog.model.ProvisionedProductPlanType {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanType =
      software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanType.CLOUDFORMATION
  }
}
