package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeProductViewResponse(
    productViewSummary: Optional[
      zio.aws.servicecatalog.model.ProductViewSummary
    ] = Optional.Absent,
    provisioningArtifacts: Optional[
      Iterable[zio.aws.servicecatalog.model.ProvisioningArtifact]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribeProductViewResponse = {
    import DescribeProductViewResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribeProductViewResponse
      .builder()
      .optionallyWith(productViewSummary.map(value => value.buildAwsValue()))(
        _.productViewSummary
      )
      .optionallyWith(
        provisioningArtifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisioningArtifacts)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribeProductViewResponse.ReadOnly =
    zio.aws.servicecatalog.model.DescribeProductViewResponse
      .wrap(buildAwsValue())
}
object DescribeProductViewResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribeProductViewResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.DescribeProductViewResponse =
      zio.aws.servicecatalog.model.DescribeProductViewResponse(
        productViewSummary.map(value => value.asEditable),
        provisioningArtifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def productViewSummary
        : Optional[zio.aws.servicecatalog.model.ProductViewSummary.ReadOnly]
    def provisioningArtifacts: Optional[
      List[zio.aws.servicecatalog.model.ProvisioningArtifact.ReadOnly]
    ]
    def getProductViewSummary: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProductViewSummary.ReadOnly
    ] = AwsError.unwrapOptionField("productViewSummary", productViewSummary)
    def getProvisioningArtifacts: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ProvisioningArtifact.ReadOnly
    ]] =
      AwsError.unwrapOptionField("provisioningArtifacts", provisioningArtifacts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProductViewResponse
  ) extends zio.aws.servicecatalog.model.DescribeProductViewResponse.ReadOnly {
    override val productViewSummary
        : Optional[zio.aws.servicecatalog.model.ProductViewSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productViewSummary())
        .map(value =>
          zio.aws.servicecatalog.model.ProductViewSummary.wrap(value)
        )
    override val provisioningArtifacts: Optional[
      List[zio.aws.servicecatalog.model.ProvisioningArtifact.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningArtifacts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ProvisioningArtifact.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProductViewResponse
  ): zio.aws.servicecatalog.model.DescribeProductViewResponse.ReadOnly =
    new Wrapper(impl)
}
