package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.servicecatalog.model.primitives.{
  IdempotencyToken,
  Id,
  AcceptLanguage
}
import scala.jdk.CollectionConverters._
final case class CreateProvisioningArtifactRequest(
    acceptLanguage: Optional[AcceptLanguage] = Optional.Absent,
    productId: Id,
    parameters: zio.aws.servicecatalog.model.ProvisioningArtifactProperties,
    idempotencyToken: IdempotencyToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.CreateProvisioningArtifactRequest = {
    import CreateProvisioningArtifactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.CreateProvisioningArtifactRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .productId(Id.unwrap(productId): java.lang.String)
      .parameters(parameters.buildAwsValue())
      .idempotencyToken(
        IdempotencyToken.unwrap(idempotencyToken): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.CreateProvisioningArtifactRequest.ReadOnly =
    zio.aws.servicecatalog.model.CreateProvisioningArtifactRequest
      .wrap(buildAwsValue())
}
object CreateProvisioningArtifactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.CreateProvisioningArtifactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.CreateProvisioningArtifactRequest =
      zio.aws.servicecatalog.model.CreateProvisioningArtifactRequest(
        acceptLanguage.map(value => value),
        productId,
        parameters.asEditable,
        idempotencyToken
      )
    def acceptLanguage: Optional[AcceptLanguage]
    def productId: Id
    def parameters
        : zio.aws.servicecatalog.model.ProvisioningArtifactProperties.ReadOnly
    def idempotencyToken: IdempotencyToken
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getProductId: ZIO[Any, Nothing, Id] = ZIO.succeed(productId)
    def getParameters: ZIO[
      Any,
      Nothing,
      zio.aws.servicecatalog.model.ProvisioningArtifactProperties.ReadOnly
    ] = ZIO.succeed(parameters)
    def getIdempotencyToken: ZIO[Any, Nothing, IdempotencyToken] =
      ZIO.succeed(idempotencyToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreateProvisioningArtifactRequest
  ) extends zio.aws.servicecatalog.model.CreateProvisioningArtifactRequest.ReadOnly {
    override val acceptLanguage: Optional[AcceptLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptLanguage())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
        )
    override val productId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.productId())
    override val parameters
        : zio.aws.servicecatalog.model.ProvisioningArtifactProperties.ReadOnly =
      zio.aws.servicecatalog.model.ProvisioningArtifactProperties
        .wrap(impl.parameters())
    override val idempotencyToken: IdempotencyToken =
      zio.aws.servicecatalog.model.primitives
        .IdempotencyToken(impl.idempotencyToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreateProvisioningArtifactRequest
  ): zio.aws.servicecatalog.model.CreateProvisioningArtifactRequest.ReadOnly =
    new Wrapper(impl)
}
