package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdatePortfolioResponse(
    portfolioDetail: Optional[zio.aws.servicecatalog.model.PortfolioDetail] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.servicecatalog.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioResponse = {
    import UpdatePortfolioResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioResponse
      .builder()
      .optionallyWith(portfolioDetail.map(value => value.buildAwsValue()))(
        _.portfolioDetail
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.UpdatePortfolioResponse.ReadOnly =
    zio.aws.servicecatalog.model.UpdatePortfolioResponse.wrap(buildAwsValue())
}
object UpdatePortfolioResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.UpdatePortfolioResponse =
      zio.aws.servicecatalog.model.UpdatePortfolioResponse(
        portfolioDetail.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def portfolioDetail
        : Optional[zio.aws.servicecatalog.model.PortfolioDetail.ReadOnly]
    def tags: Optional[List[zio.aws.servicecatalog.model.Tag.ReadOnly]]
    def getPortfolioDetail: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.PortfolioDetail.ReadOnly
    ] = AwsError.unwrapOptionField("portfolioDetail", portfolioDetail)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioResponse
  ) extends zio.aws.servicecatalog.model.UpdatePortfolioResponse.ReadOnly {
    override val portfolioDetail
        : Optional[zio.aws.servicecatalog.model.PortfolioDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portfolioDetail())
        .map(value => zio.aws.servicecatalog.model.PortfolioDetail.wrap(value))
    override val tags
        : Optional[List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioResponse
  ): zio.aws.servicecatalog.model.UpdatePortfolioResponse.ReadOnly =
    new Wrapper(impl)
}
