package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{PropertyValue, Id}
import scala.jdk.CollectionConverters._
final case class UpdateProvisionedProductPropertiesResponse(
    provisionedProductId: Option[Id] = None,
    provisionedProductProperties: Option[
      Map[zio.aws.servicecatalog.model.PropertyKey, PropertyValue]
    ] = None,
    recordId: Option[Id] = None,
    status: Option[zio.aws.servicecatalog.model.RecordStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductPropertiesResponse = {
    import UpdateProvisionedProductPropertiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductPropertiesResponse
      .builder()
      .optionallyWith(
        provisionedProductId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisionedProductId)
      .optionallyWith(
        provisionedProductProperties.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (PropertyValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.provisionedProductPropertiesWithStrings)
      .optionallyWith(
        recordId.map(value => Id.unwrap(value): java.lang.String)
      )(_.recordId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.UpdateProvisionedProductPropertiesResponse.ReadOnly =
    zio.aws.servicecatalog.model.UpdateProvisionedProductPropertiesResponse
      .wrap(buildAwsValue())
}
object UpdateProvisionedProductPropertiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductPropertiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.UpdateProvisionedProductPropertiesResponse =
      zio.aws.servicecatalog.model.UpdateProvisionedProductPropertiesResponse(
        provisionedProductId.map(value => value),
        provisionedProductProperties.map(value => value),
        recordId.map(value => value),
        status.map(value => value)
      )
    def provisionedProductId: Option[Id]
    def provisionedProductProperties
        : Option[Map[zio.aws.servicecatalog.model.PropertyKey, PropertyValue]]
    def recordId: Option[Id]
    def status: Option[zio.aws.servicecatalog.model.RecordStatus]
    def getProvisionedProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("provisionedProductId", provisionedProductId)
    def getProvisionedProductProperties: ZIO[Any, AwsError, Map[
      zio.aws.servicecatalog.model.PropertyKey,
      PropertyValue
    ]] = AwsError.unwrapOptionField(
      "provisionedProductProperties",
      provisionedProductProperties
    )
    def getRecordId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("recordId", recordId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.RecordStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductPropertiesResponse
  ) extends zio.aws.servicecatalog.model.UpdateProvisionedProductPropertiesResponse.ReadOnly {
    override val provisionedProductId: Option[Id] = scala
      .Option(impl.provisionedProductId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val provisionedProductProperties
        : Option[Map[zio.aws.servicecatalog.model.PropertyKey, PropertyValue]] =
      scala
        .Option(impl.provisionedProductProperties())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.servicecatalog.model.PropertyKey.wrap(
                key
              ) -> zio.aws.servicecatalog.model.primitives.PropertyValue(value)
            })
            .toMap
        )
    override val recordId: Option[Id] = scala
      .Option(impl.recordId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val status: Option[zio.aws.servicecatalog.model.RecordStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.servicecatalog.model.RecordStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductPropertiesResponse
  ): zio.aws.servicecatalog.model.UpdateProvisionedProductPropertiesResponse.ReadOnly =
    new Wrapper(impl)
}
