package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.servicecatalog.model.primitives.{
  ResourceDetailDescription,
  ResourceDetailCreatedTime,
  ResourceDetailName,
  ResourceDetailARN,
  ResourceDetailId
}
import scala.jdk.CollectionConverters._
final case class ResourceDetail(
    id: Option[ResourceDetailId] = None,
    arn: Option[ResourceDetailARN] = None,
    name: Option[ResourceDetailName] = None,
    description: Option[ResourceDetailDescription] = None,
    createdTime: Option[ResourceDetailCreatedTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ResourceDetail = {
    import ResourceDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ResourceDetail
      .builder()
      .optionallyWith(
        id.map(value => ResourceDetailId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        arn.map(value => ResourceDetailARN.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => ResourceDetailName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ResourceDetailDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        createdTime.map(value =>
          ResourceDetailCreatedTime.unwrap(value): Instant
        )
      )(_.createdTime)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.ResourceDetail.ReadOnly =
    zio.aws.servicecatalog.model.ResourceDetail.wrap(buildAwsValue())
}
object ResourceDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ResourceDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ResourceDetail =
      zio.aws.servicecatalog.model.ResourceDetail(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        createdTime.map(value => value)
      )
    def id: Option[ResourceDetailId]
    def arn: Option[ResourceDetailARN]
    def name: Option[ResourceDetailName]
    def description: Option[ResourceDetailDescription]
    def createdTime: Option[ResourceDetailCreatedTime]
    def getId: ZIO[Any, AwsError, ResourceDetailId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ResourceDetailARN] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ResourceDetailName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ResourceDetailDescription] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedTime: ZIO[Any, AwsError, ResourceDetailCreatedTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ResourceDetail
  ) extends zio.aws.servicecatalog.model.ResourceDetail.ReadOnly {
    override val id: Option[ResourceDetailId] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ResourceDetailId(value)
      )
    override val arn: Option[ResourceDetailARN] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ResourceDetailARN(value)
      )
    override val name: Option[ResourceDetailName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ResourceDetailName(value)
      )
    override val description: Option[ResourceDetailDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ResourceDetailDescription(value)
      )
    override val createdTime: Option[ResourceDetailCreatedTime] = scala
      .Option(impl.createdTime())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ResourceDetailCreatedTime(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ResourceDetail
  ): zio.aws.servicecatalog.model.ResourceDetail.ReadOnly = new Wrapper(impl)
}
