package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  ParameterKey,
  DefaultValue,
  NoEcho,
  Description,
  ParameterType
}
import scala.jdk.CollectionConverters._
final case class ProvisioningArtifactParameter(
    parameterKey: Option[ParameterKey] = None,
    defaultValue: Option[DefaultValue] = None,
    parameterType: Option[ParameterType] = None,
    isNoEcho: Option[NoEcho] = None,
    description: Option[Description] = None,
    parameterConstraints: Option[
      zio.aws.servicecatalog.model.ParameterConstraints
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactParameter = {
    import ProvisioningArtifactParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactParameter
      .builder()
      .optionallyWith(
        parameterKey.map(value => ParameterKey.unwrap(value): java.lang.String)
      )(_.parameterKey)
      .optionallyWith(
        defaultValue.map(value => DefaultValue.unwrap(value): java.lang.String)
      )(_.defaultValue)
      .optionallyWith(
        parameterType.map(value =>
          ParameterType.unwrap(value): java.lang.String
        )
      )(_.parameterType)
      .optionallyWith(
        isNoEcho.map(value => NoEcho.unwrap(value): java.lang.Boolean)
      )(_.isNoEcho)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(parameterConstraints.map(value => value.buildAwsValue()))(
        _.parameterConstraints
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ProvisioningArtifactParameter.ReadOnly =
    zio.aws.servicecatalog.model.ProvisioningArtifactParameter
      .wrap(buildAwsValue())
}
object ProvisioningArtifactParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ProvisioningArtifactParameter =
      zio.aws.servicecatalog.model.ProvisioningArtifactParameter(
        parameterKey.map(value => value),
        defaultValue.map(value => value),
        parameterType.map(value => value),
        isNoEcho.map(value => value),
        description.map(value => value),
        parameterConstraints.map(value => value.asEditable)
      )
    def parameterKey: Option[ParameterKey]
    def defaultValue: Option[DefaultValue]
    def parameterType: Option[ParameterType]
    def isNoEcho: Option[NoEcho]
    def description: Option[Description]
    def parameterConstraints
        : Option[zio.aws.servicecatalog.model.ParameterConstraints.ReadOnly]
    def getParameterKey: ZIO[Any, AwsError, ParameterKey] =
      AwsError.unwrapOptionField("parameterKey", parameterKey)
    def getDefaultValue: ZIO[Any, AwsError, DefaultValue] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getParameterType: ZIO[Any, AwsError, ParameterType] =
      AwsError.unwrapOptionField("parameterType", parameterType)
    def getIsNoEcho: ZIO[Any, AwsError, NoEcho] =
      AwsError.unwrapOptionField("isNoEcho", isNoEcho)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getParameterConstraints: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ParameterConstraints.ReadOnly
    ] = AwsError.unwrapOptionField("parameterConstraints", parameterConstraints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactParameter
  ) extends zio.aws.servicecatalog.model.ProvisioningArtifactParameter.ReadOnly {
    override val parameterKey: Option[ParameterKey] = scala
      .Option(impl.parameterKey())
      .map(value => zio.aws.servicecatalog.model.primitives.ParameterKey(value))
    override val defaultValue: Option[DefaultValue] = scala
      .Option(impl.defaultValue())
      .map(value => zio.aws.servicecatalog.model.primitives.DefaultValue(value))
    override val parameterType: Option[ParameterType] = scala
      .Option(impl.parameterType())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ParameterType(value)
      )
    override val isNoEcho: Option[NoEcho] = scala
      .Option(impl.isNoEcho())
      .map(value => zio.aws.servicecatalog.model.primitives.NoEcho(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.servicecatalog.model.primitives.Description(value))
    override val parameterConstraints
        : Option[zio.aws.servicecatalog.model.ParameterConstraints.ReadOnly] =
      scala
        .Option(impl.parameterConstraints())
        .map(value =>
          zio.aws.servicecatalog.model.ParameterConstraints.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactParameter
  ): zio.aws.servicecatalog.model.ProvisioningArtifactParameter.ReadOnly =
    new Wrapper(impl)
}
