package zio.aws.servicecatalog.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  PageSize,
  PageToken,
  Id,
  AcceptLanguage
}
import scala.jdk.CollectionConverters._
final case class ListStackInstancesForProvisionedProductRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    provisionedProductId: Id,
    pageToken: Option[PageToken] = None,
    pageSize: Option[PageSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListStackInstancesForProvisionedProductRequest = {
    import ListStackInstancesForProvisionedProductRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListStackInstancesForProvisionedProductRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .provisionedProductId(Id.unwrap(provisionedProductId): java.lang.String)
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListStackInstancesForProvisionedProductRequest.ReadOnly =
    zio.aws.servicecatalog.model.ListStackInstancesForProvisionedProductRequest
      .wrap(buildAwsValue())
}
object ListStackInstancesForProvisionedProductRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListStackInstancesForProvisionedProductRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ListStackInstancesForProvisionedProductRequest =
      zio.aws.servicecatalog.model
        .ListStackInstancesForProvisionedProductRequest(
          acceptLanguage.map(value => value),
          provisionedProductId,
          pageToken.map(value => value),
          pageSize.map(value => value)
        )
    def acceptLanguage: Option[AcceptLanguage]
    def provisionedProductId: Id
    def pageToken: Option[PageToken]
    def pageSize: Option[PageSize]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getProvisionedProductId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(provisionedProductId)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListStackInstancesForProvisionedProductRequest
  ) extends zio.aws.servicecatalog.model.ListStackInstancesForProvisionedProductRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val provisionedProductId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.provisionedProductId())
    override val pageToken: Option[PageToken] = scala
      .Option(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
    override val pageSize: Option[PageSize] = scala
      .Option(impl.pageSize())
      .map(value => zio.aws.servicecatalog.model.primitives.PageSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListStackInstancesForProvisionedProductRequest
  ): zio.aws.servicecatalog.model.ListStackInstancesForProvisionedProductRequest.ReadOnly =
    new Wrapper(impl)
}
