package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class ListServiceActionsResponse(
    serviceActionSummaries: Option[
      Iterable[zio.aws.servicecatalog.model.ServiceActionSummary]
    ] = None,
    nextPageToken: Option[PageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsResponse = {
    import ListServiceActionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsResponse
      .builder()
      .optionallyWith(
        serviceActionSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceActionSummaries)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListServiceActionsResponse.ReadOnly =
    zio.aws.servicecatalog.model.ListServiceActionsResponse
      .wrap(buildAwsValue())
}
object ListServiceActionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ListServiceActionsResponse =
      zio.aws.servicecatalog.model.ListServiceActionsResponse(
        serviceActionSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def serviceActionSummaries: Option[
      List[zio.aws.servicecatalog.model.ServiceActionSummary.ReadOnly]
    ]
    def nextPageToken: Option[PageToken]
    def getServiceActionSummaries: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ServiceActionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "serviceActionSummaries",
      serviceActionSummaries
    )
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsResponse
  ) extends zio.aws.servicecatalog.model.ListServiceActionsResponse.ReadOnly {
    override val serviceActionSummaries: Option[
      List[zio.aws.servicecatalog.model.ServiceActionSummary.ReadOnly]
    ] = scala
      .Option(impl.serviceActionSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ServiceActionSummary.wrap(item)
        }.toList
      )
    override val nextPageToken: Option[PageToken] = scala
      .Option(impl.nextPageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsResponse
  ): zio.aws.servicecatalog.model.ListServiceActionsResponse.ReadOnly =
    new Wrapper(impl)
}
