package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class ListPortfoliosResponse(
    portfolioDetails: Option[
      Iterable[zio.aws.servicecatalog.model.PortfolioDetail]
    ] = None,
    nextPageToken: Option[PageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosResponse = {
    import ListPortfoliosResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosResponse
      .builder()
      .optionallyWith(
        portfolioDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.portfolioDetails)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.ListPortfoliosResponse.ReadOnly =
    zio.aws.servicecatalog.model.ListPortfoliosResponse.wrap(buildAwsValue())
}
object ListPortfoliosResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ListPortfoliosResponse =
      zio.aws.servicecatalog.model.ListPortfoliosResponse(
        portfolioDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def portfolioDetails
        : Option[List[zio.aws.servicecatalog.model.PortfolioDetail.ReadOnly]]
    def nextPageToken: Option[PageToken]
    def getPortfolioDetails: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.PortfolioDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("portfolioDetails", portfolioDetails)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosResponse
  ) extends zio.aws.servicecatalog.model.ListPortfoliosResponse.ReadOnly {
    override val portfolioDetails
        : Option[List[zio.aws.servicecatalog.model.PortfolioDetail.ReadOnly]] =
      scala
        .Option(impl.portfolioDetails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.PortfolioDetail.wrap(item)
          }.toList
        )
    override val nextPageToken: Option[PageToken] = scala
      .Option(impl.nextPageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosResponse
  ): zio.aws.servicecatalog.model.ListPortfoliosResponse.ReadOnly = new Wrapper(
    impl
  )
}
