package zio.aws.servicecatalog.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  PageSizeMax100,
  PageToken,
  Id,
  AcceptLanguage
}
import scala.jdk.CollectionConverters._
final case class ListPortfolioAccessRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    portfolioId: Id,
    organizationParentId: Option[Id] = None,
    pageToken: Option[PageToken] = None,
    pageSize: Option[PageSizeMax100] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest = {
    import ListPortfolioAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .portfolioId(Id.unwrap(portfolioId): java.lang.String)
      .optionallyWith(
        organizationParentId.map(value => Id.unwrap(value): java.lang.String)
      )(_.organizationParentId)
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .optionallyWith(
        pageSize.map(value => PageSizeMax100.unwrap(value): Integer)
      )(_.pageSize)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListPortfolioAccessRequest.ReadOnly =
    zio.aws.servicecatalog.model.ListPortfolioAccessRequest
      .wrap(buildAwsValue())
}
object ListPortfolioAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ListPortfolioAccessRequest =
      zio.aws.servicecatalog.model.ListPortfolioAccessRequest(
        acceptLanguage.map(value => value),
        portfolioId,
        organizationParentId.map(value => value),
        pageToken.map(value => value),
        pageSize.map(value => value)
      )
    def acceptLanguage: Option[AcceptLanguage]
    def portfolioId: Id
    def organizationParentId: Option[Id]
    def pageToken: Option[PageToken]
    def pageSize: Option[PageSizeMax100]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getPortfolioId: ZIO[Any, Nothing, Id] = ZIO.succeed(portfolioId)
    def getOrganizationParentId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("organizationParentId", organizationParentId)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
    def getPageSize: ZIO[Any, AwsError, PageSizeMax100] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest
  ) extends zio.aws.servicecatalog.model.ListPortfolioAccessRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val portfolioId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.portfolioId())
    override val organizationParentId: Option[Id] = scala
      .Option(impl.organizationParentId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val pageToken: Option[PageToken] = scala
      .Option(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
    override val pageSize: Option[PageSizeMax100] = scala
      .Option(impl.pageSize())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.PageSizeMax100(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest
  ): zio.aws.servicecatalog.model.ListPortfolioAccessRequest.ReadOnly =
    new Wrapper(impl)
}
