package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImportAsProvisionedProductResponse(
    recordDetail: Option[zio.aws.servicecatalog.model.RecordDetail] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ImportAsProvisionedProductResponse = {
    import ImportAsProvisionedProductResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ImportAsProvisionedProductResponse
      .builder()
      .optionallyWith(recordDetail.map(value => value.buildAwsValue()))(
        _.recordDetail
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ImportAsProvisionedProductResponse.ReadOnly =
    zio.aws.servicecatalog.model.ImportAsProvisionedProductResponse
      .wrap(buildAwsValue())
}
object ImportAsProvisionedProductResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ImportAsProvisionedProductResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ImportAsProvisionedProductResponse =
      zio.aws.servicecatalog.model.ImportAsProvisionedProductResponse(
        recordDetail.map(value => value.asEditable)
      )
    def recordDetail: Option[zio.aws.servicecatalog.model.RecordDetail.ReadOnly]
    def getRecordDetail: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.RecordDetail.ReadOnly
    ] = AwsError.unwrapOptionField("recordDetail", recordDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ImportAsProvisionedProductResponse
  ) extends zio.aws.servicecatalog.model.ImportAsProvisionedProductResponse.ReadOnly {
    override val recordDetail
        : Option[zio.aws.servicecatalog.model.RecordDetail.ReadOnly] = scala
      .Option(impl.recordDetail())
      .map(value => zio.aws.servicecatalog.model.RecordDetail.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ImportAsProvisionedProductResponse
  ): zio.aws.servicecatalog.model.ImportAsProvisionedProductResponse.ReadOnly =
    new Wrapper(impl)
}
