package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.servicecatalog.model.primitives.{TagOptionId, ResourceId}
import scala.jdk.CollectionConverters._
final case class DisassociateTagOptionFromResourceRequest(
    resourceId: ResourceId,
    tagOptionId: TagOptionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DisassociateTagOptionFromResourceRequest = {
    import DisassociateTagOptionFromResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DisassociateTagOptionFromResourceRequest
      .builder()
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .tagOptionId(TagOptionId.unwrap(tagOptionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DisassociateTagOptionFromResourceRequest.ReadOnly =
    zio.aws.servicecatalog.model.DisassociateTagOptionFromResourceRequest
      .wrap(buildAwsValue())
}
object DisassociateTagOptionFromResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DisassociateTagOptionFromResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.DisassociateTagOptionFromResourceRequest =
      zio.aws.servicecatalog.model
        .DisassociateTagOptionFromResourceRequest(resourceId, tagOptionId)
    def resourceId: ResourceId
    def tagOptionId: TagOptionId
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
    def getTagOptionId: ZIO[Any, Nothing, TagOptionId] =
      ZIO.succeed(tagOptionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DisassociateTagOptionFromResourceRequest
  ) extends zio.aws.servicecatalog.model.DisassociateTagOptionFromResourceRequest.ReadOnly {
    override val resourceId: ResourceId =
      zio.aws.servicecatalog.model.primitives.ResourceId(impl.resourceId())
    override val tagOptionId: TagOptionId =
      zio.aws.servicecatalog.model.primitives.TagOptionId(impl.tagOptionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DisassociateTagOptionFromResourceRequest
  ): zio.aws.servicecatalog.model.DisassociateTagOptionFromResourceRequest.ReadOnly =
    new Wrapper(impl)
}
