package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeProvisioningParametersResponse(
    provisioningArtifactParameters: Option[
      Iterable[zio.aws.servicecatalog.model.ProvisioningArtifactParameter]
    ] = None,
    constraintSummaries: Option[
      Iterable[zio.aws.servicecatalog.model.ConstraintSummary]
    ] = None,
    usageInstructions: Option[
      Iterable[zio.aws.servicecatalog.model.UsageInstruction]
    ] = None,
    tagOptions: Option[
      Iterable[zio.aws.servicecatalog.model.TagOptionSummary]
    ] = None,
    provisioningArtifactPreferences: Option[
      zio.aws.servicecatalog.model.ProvisioningArtifactPreferences
    ] = None,
    provisioningArtifactOutputs: Option[
      Iterable[zio.aws.servicecatalog.model.ProvisioningArtifactOutput]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersResponse = {
    import DescribeProvisioningParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersResponse
      .builder()
      .optionallyWith(
        provisioningArtifactParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisioningArtifactParameters)
      .optionallyWith(
        constraintSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.constraintSummaries)
      .optionallyWith(
        usageInstructions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.usageInstructions)
      .optionallyWith(
        tagOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagOptions)
      .optionallyWith(
        provisioningArtifactPreferences.map(value => value.buildAwsValue())
      )(_.provisioningArtifactPreferences)
      .optionallyWith(
        provisioningArtifactOutputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisioningArtifactOutputs)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribeProvisioningParametersResponse.ReadOnly =
    zio.aws.servicecatalog.model.DescribeProvisioningParametersResponse
      .wrap(buildAwsValue())
}
object DescribeProvisioningParametersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.DescribeProvisioningParametersResponse =
      zio.aws.servicecatalog.model.DescribeProvisioningParametersResponse(
        provisioningArtifactParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        constraintSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        usageInstructions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tagOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        provisioningArtifactPreferences.map(value => value.asEditable),
        provisioningArtifactOutputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def provisioningArtifactParameters: Option[
      List[zio.aws.servicecatalog.model.ProvisioningArtifactParameter.ReadOnly]
    ]
    def constraintSummaries
        : Option[List[zio.aws.servicecatalog.model.ConstraintSummary.ReadOnly]]
    def usageInstructions
        : Option[List[zio.aws.servicecatalog.model.UsageInstruction.ReadOnly]]
    def tagOptions
        : Option[List[zio.aws.servicecatalog.model.TagOptionSummary.ReadOnly]]
    def provisioningArtifactPreferences: Option[
      zio.aws.servicecatalog.model.ProvisioningArtifactPreferences.ReadOnly
    ]
    def provisioningArtifactOutputs: Option[
      List[zio.aws.servicecatalog.model.ProvisioningArtifactOutput.ReadOnly]
    ]
    def getProvisioningArtifactParameters: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ProvisioningArtifactParameter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "provisioningArtifactParameters",
      provisioningArtifactParameters
    )
    def getConstraintSummaries: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ConstraintSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("constraintSummaries", constraintSummaries)
    def getUsageInstructions: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.UsageInstruction.ReadOnly
    ]] = AwsError.unwrapOptionField("usageInstructions", usageInstructions)
    def getTagOptions: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.TagOptionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("tagOptions", tagOptions)
    def getProvisioningArtifactPreferences: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProvisioningArtifactPreferences.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisioningArtifactPreferences",
      provisioningArtifactPreferences
    )
    def getProvisioningArtifactOutputs: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ProvisioningArtifactOutput.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "provisioningArtifactOutputs",
      provisioningArtifactOutputs
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersResponse
  ) extends zio.aws.servicecatalog.model.DescribeProvisioningParametersResponse.ReadOnly {
    override val provisioningArtifactParameters: Option[
      List[zio.aws.servicecatalog.model.ProvisioningArtifactParameter.ReadOnly]
    ] = scala
      .Option(impl.provisioningArtifactParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ProvisioningArtifactParameter.wrap(item)
        }.toList
      )
    override val constraintSummaries: Option[
      List[zio.aws.servicecatalog.model.ConstraintSummary.ReadOnly]
    ] = scala
      .Option(impl.constraintSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ConstraintSummary.wrap(item)
        }.toList
      )
    override val usageInstructions
        : Option[List[zio.aws.servicecatalog.model.UsageInstruction.ReadOnly]] =
      scala
        .Option(impl.usageInstructions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.UsageInstruction.wrap(item)
          }.toList
        )
    override val tagOptions
        : Option[List[zio.aws.servicecatalog.model.TagOptionSummary.ReadOnly]] =
      scala
        .Option(impl.tagOptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.TagOptionSummary.wrap(item)
          }.toList
        )
    override val provisioningArtifactPreferences: Option[
      zio.aws.servicecatalog.model.ProvisioningArtifactPreferences.ReadOnly
    ] = scala
      .Option(impl.provisioningArtifactPreferences())
      .map(value =>
        zio.aws.servicecatalog.model.ProvisioningArtifactPreferences.wrap(value)
      )
    override val provisioningArtifactOutputs: Option[
      List[zio.aws.servicecatalog.model.ProvisioningArtifactOutput.ReadOnly]
    ] = scala
      .Option(impl.provisioningArtifactOutputs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ProvisioningArtifactOutput.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersResponse
  ): zio.aws.servicecatalog.model.DescribeProvisioningParametersResponse.ReadOnly =
    new Wrapper(impl)
}
