package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeProvisionedProductResponse(
    provisionedProductDetail: Option[
      zio.aws.servicecatalog.model.ProvisionedProductDetail
    ] = None,
    cloudWatchDashboards: Option[
      Iterable[zio.aws.servicecatalog.model.CloudWatchDashboard]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductResponse = {
    import DescribeProvisionedProductResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductResponse
      .builder()
      .optionallyWith(
        provisionedProductDetail.map(value => value.buildAwsValue())
      )(_.provisionedProductDetail)
      .optionallyWith(
        cloudWatchDashboards.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cloudWatchDashboards)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribeProvisionedProductResponse.ReadOnly =
    zio.aws.servicecatalog.model.DescribeProvisionedProductResponse
      .wrap(buildAwsValue())
}
object DescribeProvisionedProductResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.DescribeProvisionedProductResponse =
      zio.aws.servicecatalog.model.DescribeProvisionedProductResponse(
        provisionedProductDetail.map(value => value.asEditable),
        cloudWatchDashboards.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def provisionedProductDetail
        : Option[zio.aws.servicecatalog.model.ProvisionedProductDetail.ReadOnly]
    def cloudWatchDashboards: Option[
      List[zio.aws.servicecatalog.model.CloudWatchDashboard.ReadOnly]
    ]
    def getProvisionedProductDetail: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProvisionedProductDetail.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisionedProductDetail",
      provisionedProductDetail
    )
    def getCloudWatchDashboards: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.CloudWatchDashboard.ReadOnly
    ]] =
      AwsError.unwrapOptionField("cloudWatchDashboards", cloudWatchDashboards)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductResponse
  ) extends zio.aws.servicecatalog.model.DescribeProvisionedProductResponse.ReadOnly {
    override val provisionedProductDetail: Option[
      zio.aws.servicecatalog.model.ProvisionedProductDetail.ReadOnly
    ] = scala
      .Option(impl.provisionedProductDetail())
      .map(value =>
        zio.aws.servicecatalog.model.ProvisionedProductDetail.wrap(value)
      )
    override val cloudWatchDashboards: Option[
      List[zio.aws.servicecatalog.model.CloudWatchDashboard.ReadOnly]
    ] = scala
      .Option(impl.cloudWatchDashboards())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.CloudWatchDashboard.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductResponse
  ): zio.aws.servicecatalog.model.DescribeProvisionedProductResponse.ReadOnly =
    new Wrapper(impl)
}
