package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeProductAsAdminResponse(
    productViewDetail: Option[zio.aws.servicecatalog.model.ProductViewDetail] =
      None,
    provisioningArtifactSummaries: Option[
      Iterable[zio.aws.servicecatalog.model.ProvisioningArtifactSummary]
    ] = None,
    tags: Option[Iterable[zio.aws.servicecatalog.model.Tag]] = None,
    tagOptions: Option[Iterable[zio.aws.servicecatalog.model.TagOptionDetail]] =
      None,
    budgets: Option[Iterable[zio.aws.servicecatalog.model.BudgetDetail]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminResponse = {
    import DescribeProductAsAdminResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminResponse
      .builder()
      .optionallyWith(productViewDetail.map(value => value.buildAwsValue()))(
        _.productViewDetail
      )
      .optionallyWith(
        provisioningArtifactSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisioningArtifactSummaries)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        tagOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagOptions)
      .optionallyWith(
        budgets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.budgets)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribeProductAsAdminResponse.ReadOnly =
    zio.aws.servicecatalog.model.DescribeProductAsAdminResponse
      .wrap(buildAwsValue())
}
object DescribeProductAsAdminResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.DescribeProductAsAdminResponse =
      zio.aws.servicecatalog.model.DescribeProductAsAdminResponse(
        productViewDetail.map(value => value.asEditable),
        provisioningArtifactSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tagOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        budgets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def productViewDetail
        : Option[zio.aws.servicecatalog.model.ProductViewDetail.ReadOnly]
    def provisioningArtifactSummaries: Option[
      List[zio.aws.servicecatalog.model.ProvisioningArtifactSummary.ReadOnly]
    ]
    def tags: Option[List[zio.aws.servicecatalog.model.Tag.ReadOnly]]
    def tagOptions
        : Option[List[zio.aws.servicecatalog.model.TagOptionDetail.ReadOnly]]
    def budgets
        : Option[List[zio.aws.servicecatalog.model.BudgetDetail.ReadOnly]]
    def getProductViewDetail: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProductViewDetail.ReadOnly
    ] = AwsError.unwrapOptionField("productViewDetail", productViewDetail)
    def getProvisioningArtifactSummaries: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ProvisioningArtifactSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "provisioningArtifactSummaries",
      provisioningArtifactSummaries
    )
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTagOptions: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.TagOptionDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("tagOptions", tagOptions)
    def getBudgets: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.BudgetDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("budgets", budgets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminResponse
  ) extends zio.aws.servicecatalog.model.DescribeProductAsAdminResponse.ReadOnly {
    override val productViewDetail
        : Option[zio.aws.servicecatalog.model.ProductViewDetail.ReadOnly] =
      scala
        .Option(impl.productViewDetail())
        .map(value =>
          zio.aws.servicecatalog.model.ProductViewDetail.wrap(value)
        )
    override val provisioningArtifactSummaries: Option[
      List[zio.aws.servicecatalog.model.ProvisioningArtifactSummary.ReadOnly]
    ] = scala
      .Option(impl.provisioningArtifactSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ProvisioningArtifactSummary.wrap(item)
        }.toList
      )
    override val tags: Option[List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.Tag.wrap(item)
          }.toList
        )
    override val tagOptions
        : Option[List[zio.aws.servicecatalog.model.TagOptionDetail.ReadOnly]] =
      scala
        .Option(impl.tagOptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.TagOptionDetail.wrap(item)
          }.toList
        )
    override val budgets
        : Option[List[zio.aws.servicecatalog.model.BudgetDetail.ReadOnly]] =
      scala
        .Option(impl.budgets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.BudgetDetail.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminResponse
  ): zio.aws.servicecatalog.model.DescribeProductAsAdminResponse.ReadOnly =
    new Wrapper(impl)
}
