package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  ProvisioningArtifactInfoValue,
  ProvisioningArtifactInfoKey
}
import scala.jdk.CollectionConverters._
final case class CreateProvisioningArtifactResponse(
    provisioningArtifactDetail: Option[
      zio.aws.servicecatalog.model.ProvisioningArtifactDetail
    ] = None,
    info: Option[
      Map[ProvisioningArtifactInfoKey, ProvisioningArtifactInfoValue]
    ] = None,
    status: Option[zio.aws.servicecatalog.model.Status] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.CreateProvisioningArtifactResponse = {
    import CreateProvisioningArtifactResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.CreateProvisioningArtifactResponse
      .builder()
      .optionallyWith(
        provisioningArtifactDetail.map(value => value.buildAwsValue())
      )(_.provisioningArtifactDetail)
      .optionallyWith(
        info.map(value =>
          value
            .map({ case (key, value) =>
              (ProvisioningArtifactInfoKey.unwrap(
                key
              ): java.lang.String) -> (ProvisioningArtifactInfoValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.info)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.CreateProvisioningArtifactResponse.ReadOnly =
    zio.aws.servicecatalog.model.CreateProvisioningArtifactResponse
      .wrap(buildAwsValue())
}
object CreateProvisioningArtifactResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.CreateProvisioningArtifactResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.CreateProvisioningArtifactResponse =
      zio.aws.servicecatalog.model.CreateProvisioningArtifactResponse(
        provisioningArtifactDetail.map(value => value.asEditable),
        info.map(value => value),
        status.map(value => value)
      )
    def provisioningArtifactDetail: Option[
      zio.aws.servicecatalog.model.ProvisioningArtifactDetail.ReadOnly
    ]
    def info: Option[
      Map[ProvisioningArtifactInfoKey, ProvisioningArtifactInfoValue]
    ]
    def status: Option[zio.aws.servicecatalog.model.Status]
    def getProvisioningArtifactDetail: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProvisioningArtifactDetail.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisioningArtifactDetail",
      provisioningArtifactDetail
    )
    def getInfo: ZIO[Any, AwsError, Map[
      ProvisioningArtifactInfoKey,
      ProvisioningArtifactInfoValue
    ]] = AwsError.unwrapOptionField("info", info)
    def getStatus: ZIO[Any, AwsError, zio.aws.servicecatalog.model.Status] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreateProvisioningArtifactResponse
  ) extends zio.aws.servicecatalog.model.CreateProvisioningArtifactResponse.ReadOnly {
    override val provisioningArtifactDetail: Option[
      zio.aws.servicecatalog.model.ProvisioningArtifactDetail.ReadOnly
    ] = scala
      .Option(impl.provisioningArtifactDetail())
      .map(value =>
        zio.aws.servicecatalog.model.ProvisioningArtifactDetail.wrap(value)
      )
    override val info: Option[
      Map[ProvisioningArtifactInfoKey, ProvisioningArtifactInfoValue]
    ] = scala
      .Option(impl.info())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.servicecatalog.model.primitives.ProvisioningArtifactInfoKey(
              key
            ) -> zio.aws.servicecatalog.model.primitives
              .ProvisioningArtifactInfoValue(value)
          })
          .toMap
      )
    override val status: Option[zio.aws.servicecatalog.model.Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.servicecatalog.model.Status.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreateProvisioningArtifactResponse
  ): zio.aws.servicecatalog.model.CreateProvisioningArtifactResponse.ReadOnly =
    new Wrapper(impl)
}
