package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.ServiceActionDefinitionValue
import scala.jdk.CollectionConverters._
final case class ServiceActionDetail(
    serviceActionSummary: Option[
      zio.aws.servicecatalog.model.ServiceActionSummary
    ] = None,
    definition: Option[Map[
      zio.aws.servicecatalog.model.ServiceActionDefinitionKey,
      ServiceActionDefinitionValue
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ServiceActionDetail = {
    import ServiceActionDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ServiceActionDetail
      .builder()
      .optionallyWith(serviceActionSummary.map(value => value.buildAwsValue()))(
        _.serviceActionSummary
      )
      .optionallyWith(
        definition.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (ServiceActionDefinitionValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.definitionWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.ServiceActionDetail.ReadOnly =
    zio.aws.servicecatalog.model.ServiceActionDetail.wrap(buildAwsValue())
}
object ServiceActionDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ServiceActionDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ServiceActionDetail =
      zio.aws.servicecatalog.model.ServiceActionDetail(
        serviceActionSummary.map(value => value.asEditable),
        definition.map(value => value)
      )
    def serviceActionSummary
        : Option[zio.aws.servicecatalog.model.ServiceActionSummary.ReadOnly]
    def definition: Option[Map[
      zio.aws.servicecatalog.model.ServiceActionDefinitionKey,
      ServiceActionDefinitionValue
    ]]
    def getServiceActionSummary: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ServiceActionSummary.ReadOnly
    ] = AwsError.unwrapOptionField("serviceActionSummary", serviceActionSummary)
    def getDefinition: ZIO[Any, AwsError, Map[
      zio.aws.servicecatalog.model.ServiceActionDefinitionKey,
      ServiceActionDefinitionValue
    ]] = AwsError.unwrapOptionField("definition", definition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ServiceActionDetail
  ) extends zio.aws.servicecatalog.model.ServiceActionDetail.ReadOnly {
    override val serviceActionSummary
        : Option[zio.aws.servicecatalog.model.ServiceActionSummary.ReadOnly] =
      scala
        .Option(impl.serviceActionSummary())
        .map(value =>
          zio.aws.servicecatalog.model.ServiceActionSummary.wrap(value)
        )
    override val definition: Option[Map[
      zio.aws.servicecatalog.model.ServiceActionDefinitionKey,
      ServiceActionDefinitionValue
    ]] = scala
      .Option(impl.definition())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.servicecatalog.model.ServiceActionDefinitionKey
              .wrap(key) -> zio.aws.servicecatalog.model.primitives
              .ServiceActionDefinitionValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ServiceActionDetail
  ): zio.aws.servicecatalog.model.ServiceActionDetail.ReadOnly = new Wrapper(
    impl
  )
}
