package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  PageToken,
  ProductViewAggregationType
}
import scala.jdk.CollectionConverters._
final case class SearchProductsResponse(
    productViewSummaries: Option[
      Iterable[zio.aws.servicecatalog.model.ProductViewSummary]
    ] = None,
    productViewAggregations: Option[Map[ProductViewAggregationType, Iterable[
      zio.aws.servicecatalog.model.ProductViewAggregationValue
    ]]] = None,
    nextPageToken: Option[PageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.SearchProductsResponse = {
    import SearchProductsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.SearchProductsResponse
      .builder()
      .optionallyWith(
        productViewSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productViewSummaries)
      .optionallyWith(
        productViewAggregations.map(value =>
          value
            .map({ case (key, value) =>
              (ProductViewAggregationType
                .unwrap(key): java.lang.String) -> value.map { item =>
                item.buildAwsValue()
              }.asJavaCollection
            })
            .asJava
        )
      )(_.productViewAggregations)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.SearchProductsResponse.ReadOnly =
    zio.aws.servicecatalog.model.SearchProductsResponse.wrap(buildAwsValue())
}
object SearchProductsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.SearchProductsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.SearchProductsResponse =
      zio.aws.servicecatalog.model.SearchProductsResponse(
        productViewSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        productViewAggregations.map(value =>
          value.map({ case (key, value) =>
            key -> value.map { item =>
              item.asEditable
            }
          })
        ),
        nextPageToken.map(value => value)
      )
    def productViewSummaries
        : Option[List[zio.aws.servicecatalog.model.ProductViewSummary.ReadOnly]]
    def productViewAggregations: Option[Map[ProductViewAggregationType, List[
      zio.aws.servicecatalog.model.ProductViewAggregationValue.ReadOnly
    ]]]
    def nextPageToken: Option[PageToken]
    def getProductViewSummaries: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ProductViewSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("productViewSummaries", productViewSummaries)
    def getProductViewAggregations
        : ZIO[Any, AwsError, Map[ProductViewAggregationType, List[
          zio.aws.servicecatalog.model.ProductViewAggregationValue.ReadOnly
        ]]] = AwsError.unwrapOptionField(
      "productViewAggregations",
      productViewAggregations
    )
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.SearchProductsResponse
  ) extends zio.aws.servicecatalog.model.SearchProductsResponse.ReadOnly {
    override val productViewSummaries: Option[
      List[zio.aws.servicecatalog.model.ProductViewSummary.ReadOnly]
    ] = scala
      .Option(impl.productViewSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ProductViewSummary.wrap(item)
        }.toList
      )
    override val productViewAggregations
        : Option[Map[ProductViewAggregationType, List[
          zio.aws.servicecatalog.model.ProductViewAggregationValue.ReadOnly
        ]]] = scala
      .Option(impl.productViewAggregations())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.servicecatalog.model.primitives
              .ProductViewAggregationType(key) -> value.asScala.map { item =>
              zio.aws.servicecatalog.model.ProductViewAggregationValue
                .wrap(item)
            }.toList
          })
          .toMap
      )
    override val nextPageToken: Option[PageToken] = scala
      .Option(impl.nextPageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.SearchProductsResponse
  ): zio.aws.servicecatalog.model.SearchProductsResponse.ReadOnly = new Wrapper(
    impl
  )
}
