package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.PropertyName
import scala.jdk.CollectionConverters._
final case class ResourceTargetDefinition(
    attribute: Option[zio.aws.servicecatalog.model.ResourceAttribute] = None,
    name: Option[PropertyName] = None,
    requiresRecreation: Option[
      zio.aws.servicecatalog.model.RequiresRecreation
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ResourceTargetDefinition = {
    import ResourceTargetDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ResourceTargetDefinition
      .builder()
      .optionallyWith(attribute.map(value => value.unwrap))(_.attribute)
      .optionallyWith(
        name.map(value => PropertyName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(requiresRecreation.map(value => value.unwrap))(
        _.requiresRecreation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ResourceTargetDefinition.ReadOnly =
    zio.aws.servicecatalog.model.ResourceTargetDefinition.wrap(buildAwsValue())
}
object ResourceTargetDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ResourceTargetDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ResourceTargetDefinition =
      zio.aws.servicecatalog.model.ResourceTargetDefinition(
        attribute.map(value => value),
        name.map(value => value),
        requiresRecreation.map(value => value)
      )
    def attribute: Option[zio.aws.servicecatalog.model.ResourceAttribute]
    def name: Option[PropertyName]
    def requiresRecreation
        : Option[zio.aws.servicecatalog.model.RequiresRecreation]
    def getAttribute
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.ResourceAttribute] =
      AwsError.unwrapOptionField("attribute", attribute)
    def getName: ZIO[Any, AwsError, PropertyName] =
      AwsError.unwrapOptionField("name", name)
    def getRequiresRecreation
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.RequiresRecreation] =
      AwsError.unwrapOptionField("requiresRecreation", requiresRecreation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ResourceTargetDefinition
  ) extends zio.aws.servicecatalog.model.ResourceTargetDefinition.ReadOnly {
    override val attribute
        : Option[zio.aws.servicecatalog.model.ResourceAttribute] = scala
      .Option(impl.attribute())
      .map(value => zio.aws.servicecatalog.model.ResourceAttribute.wrap(value))
    override val name: Option[PropertyName] = scala
      .Option(impl.name())
      .map(value => zio.aws.servicecatalog.model.primitives.PropertyName(value))
    override val requiresRecreation
        : Option[zio.aws.servicecatalog.model.RequiresRecreation] = scala
      .Option(impl.requiresRecreation())
      .map(value => zio.aws.servicecatalog.model.RequiresRecreation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ResourceTargetDefinition
  ): zio.aws.servicecatalog.model.ResourceTargetDefinition.ReadOnly =
    new Wrapper(impl)
}
