package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  PlanResourceType,
  PhysicalResourceId,
  LogicalResourceId
}
import scala.jdk.CollectionConverters._
final case class ResourceChange(
    action: Option[zio.aws.servicecatalog.model.ChangeAction] = None,
    logicalResourceId: Option[LogicalResourceId] = None,
    physicalResourceId: Option[PhysicalResourceId] = None,
    resourceType: Option[PlanResourceType] = None,
    replacement: Option[zio.aws.servicecatalog.model.Replacement] = None,
    scope: Option[Iterable[zio.aws.servicecatalog.model.ResourceAttribute]] =
      None,
    details: Option[
      Iterable[zio.aws.servicecatalog.model.ResourceChangeDetail]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ResourceChange = {
    import ResourceChange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ResourceChange
      .builder()
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(
        logicalResourceId.map(value =>
          LogicalResourceId.unwrap(value): java.lang.String
        )
      )(_.logicalResourceId)
      .optionallyWith(
        physicalResourceId.map(value =>
          PhysicalResourceId.unwrap(value): java.lang.String
        )
      )(_.physicalResourceId)
      .optionallyWith(
        resourceType.map(value =>
          PlanResourceType.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(replacement.map(value => value.unwrap))(_.replacement)
      .optionallyWith(
        scope.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.scopeWithStrings)
      .optionallyWith(
        details.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.details)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.ResourceChange.ReadOnly =
    zio.aws.servicecatalog.model.ResourceChange.wrap(buildAwsValue())
}
object ResourceChange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ResourceChange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ResourceChange =
      zio.aws.servicecatalog.model.ResourceChange(
        action.map(value => value),
        logicalResourceId.map(value => value),
        physicalResourceId.map(value => value),
        resourceType.map(value => value),
        replacement.map(value => value),
        scope.map(value => value),
        details.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def action: Option[zio.aws.servicecatalog.model.ChangeAction]
    def logicalResourceId: Option[LogicalResourceId]
    def physicalResourceId: Option[PhysicalResourceId]
    def resourceType: Option[PlanResourceType]
    def replacement: Option[zio.aws.servicecatalog.model.Replacement]
    def scope: Option[List[zio.aws.servicecatalog.model.ResourceAttribute]]
    def details: Option[
      List[zio.aws.servicecatalog.model.ResourceChangeDetail.ReadOnly]
    ]
    def getAction
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.ChangeAction] =
      AwsError.unwrapOptionField("action", action)
    def getLogicalResourceId: ZIO[Any, AwsError, LogicalResourceId] =
      AwsError.unwrapOptionField("logicalResourceId", logicalResourceId)
    def getPhysicalResourceId: ZIO[Any, AwsError, PhysicalResourceId] =
      AwsError.unwrapOptionField("physicalResourceId", physicalResourceId)
    def getResourceType: ZIO[Any, AwsError, PlanResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getReplacement
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.Replacement] =
      AwsError.unwrapOptionField("replacement", replacement)
    def getScope: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ResourceAttribute
    ]] = AwsError.unwrapOptionField("scope", scope)
    def getDetails: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ResourceChangeDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("details", details)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ResourceChange
  ) extends zio.aws.servicecatalog.model.ResourceChange.ReadOnly {
    override val action: Option[zio.aws.servicecatalog.model.ChangeAction] =
      scala
        .Option(impl.action())
        .map(value => zio.aws.servicecatalog.model.ChangeAction.wrap(value))
    override val logicalResourceId: Option[LogicalResourceId] = scala
      .Option(impl.logicalResourceId())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.LogicalResourceId(value)
      )
    override val physicalResourceId: Option[PhysicalResourceId] = scala
      .Option(impl.physicalResourceId())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.PhysicalResourceId(value)
      )
    override val resourceType: Option[PlanResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.PlanResourceType(value)
      )
    override val replacement: Option[zio.aws.servicecatalog.model.Replacement] =
      scala
        .Option(impl.replacement())
        .map(value => zio.aws.servicecatalog.model.Replacement.wrap(value))
    override val scope
        : Option[List[zio.aws.servicecatalog.model.ResourceAttribute]] = scala
      .Option(impl.scope())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ResourceAttribute.wrap(item)
        }.toList
      )
    override val details: Option[
      List[zio.aws.servicecatalog.model.ResourceChangeDetail.ReadOnly]
    ] = scala
      .Option(impl.details())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ResourceChangeDetail.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ResourceChange
  ): zio.aws.servicecatalog.model.ResourceChange.ReadOnly = new Wrapper(impl)
}
