package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.Id
import scala.jdk.CollectionConverters._
final case class PortfolioShareDetail(
    principalId: Option[Id] = None,
    `type`: Option[zio.aws.servicecatalog.model.DescribePortfolioShareType] =
      None,
    accepted: Option[Boolean] = None,
    shareTagOptions: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.PortfolioShareDetail = {
    import PortfolioShareDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.PortfolioShareDetail
      .builder()
      .optionallyWith(
        principalId.map(value => Id.unwrap(value): java.lang.String)
      )(_.principalId)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(accepted.map(value => value: java.lang.Boolean))(
        _.accepted
      )
      .optionallyWith(shareTagOptions.map(value => value: java.lang.Boolean))(
        _.shareTagOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.PortfolioShareDetail.ReadOnly =
    zio.aws.servicecatalog.model.PortfolioShareDetail.wrap(buildAwsValue())
}
object PortfolioShareDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.PortfolioShareDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.PortfolioShareDetail =
      zio.aws.servicecatalog.model.PortfolioShareDetail(
        principalId.map(value => value),
        `type`.map(value => value),
        accepted.map(value => value),
        shareTagOptions.map(value => value)
      )
    def principalId: Option[Id]
    def `type`: Option[zio.aws.servicecatalog.model.DescribePortfolioShareType]
    def accepted: Option[Boolean]
    def shareTagOptions: Option[Boolean]
    def getPrincipalId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("principalId", principalId)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.DescribePortfolioShareType
    ] = AwsError.unwrapOptionField("type", `type`)
    def getAccepted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("accepted", accepted)
    def getShareTagOptions: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("shareTagOptions", shareTagOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.PortfolioShareDetail
  ) extends zio.aws.servicecatalog.model.PortfolioShareDetail.ReadOnly {
    override val principalId: Option[Id] = scala
      .Option(impl.principalId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val `type`
        : Option[zio.aws.servicecatalog.model.DescribePortfolioShareType] =
      scala
        .Option(impl.`type`())
        .map(value =>
          zio.aws.servicecatalog.model.DescribePortfolioShareType.wrap(value)
        )
    override val accepted: Option[Boolean] =
      scala.Option(impl.accepted()).map(value => value: Boolean)
    override val shareTagOptions: Option[Boolean] =
      scala.Option(impl.shareTagOptions()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.PortfolioShareDetail
  ): zio.aws.servicecatalog.model.PortfolioShareDetail.ReadOnly = new Wrapper(
    impl
  )
}
