package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ParameterConstraints(
    allowedValues: Option[Iterable[String]] = None,
    allowedPattern: Option[String] = None,
    constraintDescription: Option[String] = None,
    maxLength: Option[String] = None,
    minLength: Option[String] = None,
    maxValue: Option[String] = None,
    minValue: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ParameterConstraints = {
    import ParameterConstraints.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ParameterConstraints
      .builder()
      .optionallyWith(
        allowedValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.allowedValues)
      .optionallyWith(allowedPattern.map(value => value: java.lang.String))(
        _.allowedPattern
      )
      .optionallyWith(
        constraintDescription.map(value => value: java.lang.String)
      )(_.constraintDescription)
      .optionallyWith(maxLength.map(value => value: java.lang.String))(
        _.maxLength
      )
      .optionallyWith(minLength.map(value => value: java.lang.String))(
        _.minLength
      )
      .optionallyWith(maxValue.map(value => value: java.lang.String))(
        _.maxValue
      )
      .optionallyWith(minValue.map(value => value: java.lang.String))(
        _.minValue
      )
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.ParameterConstraints.ReadOnly =
    zio.aws.servicecatalog.model.ParameterConstraints.wrap(buildAwsValue())
}
object ParameterConstraints {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ParameterConstraints
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ParameterConstraints =
      zio.aws.servicecatalog.model.ParameterConstraints(
        allowedValues.map(value => value),
        allowedPattern.map(value => value),
        constraintDescription.map(value => value),
        maxLength.map(value => value),
        minLength.map(value => value),
        maxValue.map(value => value),
        minValue.map(value => value)
      )
    def allowedValues: Option[List[String]]
    def allowedPattern: Option[String]
    def constraintDescription: Option[String]
    def maxLength: Option[String]
    def minLength: Option[String]
    def maxValue: Option[String]
    def minValue: Option[String]
    def getAllowedValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("allowedValues", allowedValues)
    def getAllowedPattern: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allowedPattern", allowedPattern)
    def getConstraintDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("constraintDescription", constraintDescription)
    def getMaxLength: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxLength", maxLength)
    def getMinLength: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("minLength", minLength)
    def getMaxValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxValue", maxValue)
    def getMinValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("minValue", minValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ParameterConstraints
  ) extends zio.aws.servicecatalog.model.ParameterConstraints.ReadOnly {
    override val allowedValues: Option[List[String]] = scala
      .Option(impl.allowedValues())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val allowedPattern: Option[String] =
      scala.Option(impl.allowedPattern()).map(value => value: String)
    override val constraintDescription: Option[String] =
      scala.Option(impl.constraintDescription()).map(value => value: String)
    override val maxLength: Option[String] =
      scala.Option(impl.maxLength()).map(value => value: String)
    override val minLength: Option[String] =
      scala.Option(impl.minLength()).map(value => value: String)
    override val maxValue: Option[String] =
      scala.Option(impl.maxValue()).map(value => value: String)
    override val minValue: Option[String] =
      scala.Option(impl.minValue()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ParameterConstraints
  ): zio.aws.servicecatalog.model.ParameterConstraints.ReadOnly = new Wrapper(
    impl
  )
}
