package zio.aws.servicecatalog.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  AcceptLanguage,
  PageToken,
  PageSize,
  Id
}
import scala.jdk.CollectionConverters._
final case class ListProvisioningArtifactsForServiceActionRequest(
    serviceActionId: Id,
    pageSize: Option[PageSize] = None,
    pageToken: Option[PageToken] = None,
    acceptLanguage: Option[AcceptLanguage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest = {
    import ListProvisioningArtifactsForServiceActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest
      .builder()
      .serviceActionId(Id.unwrap(serviceActionId): java.lang.String)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest.ReadOnly =
    zio.aws.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest
      .wrap(buildAwsValue())
}
object ListProvisioningArtifactsForServiceActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest =
      zio.aws.servicecatalog.model
        .ListProvisioningArtifactsForServiceActionRequest(
          serviceActionId,
          pageSize.map(value => value),
          pageToken.map(value => value),
          acceptLanguage.map(value => value)
        )
    def serviceActionId: Id
    def pageSize: Option[PageSize]
    def pageToken: Option[PageToken]
    def acceptLanguage: Option[AcceptLanguage]
    def getServiceActionId: ZIO[Any, Nothing, Id] = ZIO.succeed(serviceActionId)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest
  ) extends zio.aws.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest.ReadOnly {
    override val serviceActionId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.serviceActionId())
    override val pageSize: Option[PageSize] = scala
      .Option(impl.pageSize())
      .map(value => zio.aws.servicecatalog.model.primitives.PageSize(value))
    override val pageToken: Option[PageToken] = scala
      .Option(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest
  ): zio.aws.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest.ReadOnly =
    new Wrapper(impl)
}
