package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  ExecutionParameterValue,
  ExecutionParameterType,
  ExecutionParameterKey
}
import scala.jdk.CollectionConverters._
final case class ExecutionParameter(
    name: Option[ExecutionParameterKey] = None,
    `type`: Option[ExecutionParameterType] = None,
    defaultValues: Option[Iterable[ExecutionParameterValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ExecutionParameter = {
    import ExecutionParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ExecutionParameter
      .builder()
      .optionallyWith(
        name.map(value => ExecutionParameterKey.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        `type`.map(value =>
          ExecutionParameterType.unwrap(value): java.lang.String
        )
      )(_.`type`)
      .optionallyWith(
        defaultValues.map(value =>
          value.map { item =>
            ExecutionParameterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.defaultValues)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.ExecutionParameter.ReadOnly =
    zio.aws.servicecatalog.model.ExecutionParameter.wrap(buildAwsValue())
}
object ExecutionParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ExecutionParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ExecutionParameter =
      zio.aws.servicecatalog.model.ExecutionParameter(
        name.map(value => value),
        `type`.map(value => value),
        defaultValues.map(value => value)
      )
    def name: Option[ExecutionParameterKey]
    def `type`: Option[ExecutionParameterType]
    def defaultValues: Option[List[ExecutionParameterValue]]
    def getName: ZIO[Any, AwsError, ExecutionParameterKey] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, ExecutionParameterType] =
      AwsError.unwrapOptionField("type", `type`)
    def getDefaultValues: ZIO[Any, AwsError, List[ExecutionParameterValue]] =
      AwsError.unwrapOptionField("defaultValues", defaultValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ExecutionParameter
  ) extends zio.aws.servicecatalog.model.ExecutionParameter.ReadOnly {
    override val name: Option[ExecutionParameterKey] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ExecutionParameterKey(value)
      )
    override val `type`: Option[ExecutionParameterType] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ExecutionParameterType(value)
      )
    override val defaultValues: Option[List[ExecutionParameterValue]] = scala
      .Option(impl.defaultValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.primitives.ExecutionParameterValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ExecutionParameter
  ): zio.aws.servicecatalog.model.ExecutionParameter.ReadOnly = new Wrapper(
    impl
  )
}
