package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  ProductViewName,
  Id,
  AcceptLanguage
}
import scala.jdk.CollectionConverters._
final case class DescribeProductAsAdminRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    id: Option[Id] = None,
    name: Option[ProductViewName] = None,
    sourcePortfolioId: Option[Id] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminRequest = {
    import DescribeProductAsAdminRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(
        name.map(value => ProductViewName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        sourcePortfolioId.map(value => Id.unwrap(value): java.lang.String)
      )(_.sourcePortfolioId)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribeProductAsAdminRequest.ReadOnly =
    zio.aws.servicecatalog.model.DescribeProductAsAdminRequest
      .wrap(buildAwsValue())
}
object DescribeProductAsAdminRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.DescribeProductAsAdminRequest =
      zio.aws.servicecatalog.model.DescribeProductAsAdminRequest(
        acceptLanguage.map(value => value),
        id.map(value => value),
        name.map(value => value),
        sourcePortfolioId.map(value => value)
      )
    def acceptLanguage: Option[AcceptLanguage]
    def id: Option[Id]
    def name: Option[ProductViewName]
    def sourcePortfolioId: Option[Id]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ProductViewName] =
      AwsError.unwrapOptionField("name", name)
    def getSourcePortfolioId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("sourcePortfolioId", sourcePortfolioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminRequest
  ) extends zio.aws.servicecatalog.model.DescribeProductAsAdminRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val id: Option[Id] = scala
      .Option(impl.id())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val name: Option[ProductViewName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProductViewName(value)
      )
    override val sourcePortfolioId: Option[Id] = scala
      .Option(impl.sourcePortfolioId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminRequest
  ): zio.aws.servicecatalog.model.DescribeProductAsAdminRequest.ReadOnly =
    new Wrapper(impl)
}
