package zio.aws.servicecatalog.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{PageSizeMax100, PageToken, Id}
import scala.jdk.CollectionConverters._
final case class DescribePortfolioSharesRequest(
    portfolioId: Id,
    `type`: zio.aws.servicecatalog.model.DescribePortfolioShareType,
    pageToken: Option[PageToken] = None,
    pageSize: Option[PageSizeMax100] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesRequest = {
    import DescribePortfolioSharesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesRequest
      .builder()
      .portfolioId(Id.unwrap(portfolioId): java.lang.String)
      .`type`(`type`.unwrap)
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .optionallyWith(
        pageSize.map(value => PageSizeMax100.unwrap(value): Integer)
      )(_.pageSize)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribePortfolioSharesRequest.ReadOnly =
    zio.aws.servicecatalog.model.DescribePortfolioSharesRequest
      .wrap(buildAwsValue())
}
object DescribePortfolioSharesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.DescribePortfolioSharesRequest =
      zio.aws.servicecatalog.model.DescribePortfolioSharesRequest(
        portfolioId,
        `type`,
        pageToken.map(value => value),
        pageSize.map(value => value)
      )
    def portfolioId: Id
    def `type`: zio.aws.servicecatalog.model.DescribePortfolioShareType
    def pageToken: Option[PageToken]
    def pageSize: Option[PageSizeMax100]
    def getPortfolioId: ZIO[Any, Nothing, Id] = ZIO.succeed(portfolioId)
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.servicecatalog.model.DescribePortfolioShareType
    ] = ZIO.succeed(`type`)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
    def getPageSize: ZIO[Any, AwsError, PageSizeMax100] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesRequest
  ) extends zio.aws.servicecatalog.model.DescribePortfolioSharesRequest.ReadOnly {
    override val portfolioId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.portfolioId())
    override val `type`
        : zio.aws.servicecatalog.model.DescribePortfolioShareType =
      zio.aws.servicecatalog.model.DescribePortfolioShareType
        .wrap(impl.`type`())
    override val pageToken: Option[PageToken] = scala
      .Option(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
    override val pageSize: Option[PageSizeMax100] = scala
      .Option(impl.pageSize())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.PageSizeMax100(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesRequest
  ): zio.aws.servicecatalog.model.DescribePortfolioSharesRequest.ReadOnly =
    new Wrapper(impl)
}
