package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{Id, AcceptLanguage}
import scala.jdk.CollectionConverters._
final case class DescribeCopyProductStatusRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    copyProductToken: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribeCopyProductStatusRequest = {
    import DescribeCopyProductStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribeCopyProductStatusRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .copyProductToken(Id.unwrap(copyProductToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribeCopyProductStatusRequest.ReadOnly =
    zio.aws.servicecatalog.model.DescribeCopyProductStatusRequest
      .wrap(buildAwsValue())
}
object DescribeCopyProductStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribeCopyProductStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.DescribeCopyProductStatusRequest =
      zio.aws.servicecatalog.model.DescribeCopyProductStatusRequest(
        acceptLanguage.map(value => value),
        copyProductToken
      )
    def acceptLanguage: Option[AcceptLanguage]
    def copyProductToken: Id
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getCopyProductToken: ZIO[Any, Nothing, Id] =
      ZIO.succeed(copyProductToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeCopyProductStatusRequest
  ) extends zio.aws.servicecatalog.model.DescribeCopyProductStatusRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val copyProductToken: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.copyProductToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeCopyProductStatusRequest
  ): zio.aws.servicecatalog.model.DescribeCopyProductStatusRequest.ReadOnly =
    new Wrapper(impl)
}
