package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{Id, AcceptLanguage}
import scala.jdk.CollectionConverters._
final case class DeleteConstraintRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    id: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DeleteConstraintRequest = {
    import DeleteConstraintRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DeleteConstraintRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .id(Id.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DeleteConstraintRequest.ReadOnly =
    zio.aws.servicecatalog.model.DeleteConstraintRequest.wrap(buildAwsValue())
}
object DeleteConstraintRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DeleteConstraintRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.DeleteConstraintRequest =
      zio.aws.servicecatalog.model
        .DeleteConstraintRequest(acceptLanguage.map(value => value), id)
    def acceptLanguage: Option[AcceptLanguage]
    def id: Id
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DeleteConstraintRequest
  ) extends zio.aws.servicecatalog.model.DeleteConstraintRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val id: Id = zio.aws.servicecatalog.model.primitives.Id(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DeleteConstraintRequest
  ): zio.aws.servicecatalog.model.DeleteConstraintRequest.ReadOnly =
    new Wrapper(impl)
}
