package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  ConstraintDescription,
  ConstraintType
}
import scala.jdk.CollectionConverters._
final case class ConstraintSummary(
    `type`: Option[ConstraintType] = None,
    description: Option[ConstraintDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ConstraintSummary = {
    import ConstraintSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ConstraintSummary
      .builder()
      .optionallyWith(
        `type`.map(value => ConstraintType.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        description.map(value =>
          ConstraintDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.ConstraintSummary.ReadOnly =
    zio.aws.servicecatalog.model.ConstraintSummary.wrap(buildAwsValue())
}
object ConstraintSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ConstraintSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ConstraintSummary =
      zio.aws.servicecatalog.model.ConstraintSummary(
        `type`.map(value => value),
        description.map(value => value)
      )
    def `type`: Option[ConstraintType]
    def description: Option[ConstraintDescription]
    def getType: ZIO[Any, AwsError, ConstraintType] =
      AwsError.unwrapOptionField("type", `type`)
    def getDescription: ZIO[Any, AwsError, ConstraintDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ConstraintSummary
  ) extends zio.aws.servicecatalog.model.ConstraintSummary.ReadOnly {
    override val `type`: Option[ConstraintType] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ConstraintType(value)
      )
    override val description: Option[ConstraintDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ConstraintDescription(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ConstraintSummary
  ): zio.aws.servicecatalog.model.ConstraintSummary.ReadOnly = new Wrapper(impl)
}
