package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  AcceptLanguage,
  ProviderName,
  PortfolioDisplayName,
  Id,
  TagKey,
  PortfolioDescription
}
import scala.jdk.CollectionConverters._
final case class UpdatePortfolioRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    id: Id,
    displayName: Option[PortfolioDisplayName] = None,
    description: Option[PortfolioDescription] = None,
    providerName: Option[ProviderName] = None,
    addTags: Option[Iterable[zio.aws.servicecatalog.model.Tag]] = None,
    removeTags: Option[Iterable[TagKey]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioRequest = {
    import UpdatePortfolioRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .id(Id.unwrap(id): java.lang.String)
      .optionallyWith(
        displayName.map(value =>
          PortfolioDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        description.map(value =>
          PortfolioDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        providerName.map(value => ProviderName.unwrap(value): java.lang.String)
      )(_.providerName)
      .optionallyWith(
        addTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addTags)
      .optionallyWith(
        removeTags.map(value =>
          value.map { item =>
            TagKey.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.removeTags)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.UpdatePortfolioRequest.ReadOnly =
    zio.aws.servicecatalog.model.UpdatePortfolioRequest.wrap(buildAwsValue())
}
object UpdatePortfolioRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.UpdatePortfolioRequest =
      zio.aws.servicecatalog.model.UpdatePortfolioRequest(
        acceptLanguage.map(value => value),
        id,
        displayName.map(value => value),
        description.map(value => value),
        providerName.map(value => value),
        addTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        removeTags.map(value => value)
      )
    def acceptLanguage: Option[AcceptLanguage]
    def id: Id
    def displayName: Option[PortfolioDisplayName]
    def description: Option[PortfolioDescription]
    def providerName: Option[ProviderName]
    def addTags: Option[List[zio.aws.servicecatalog.model.Tag.ReadOnly]]
    def removeTags: Option[List[TagKey]]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
    def getDisplayName: ZIO[Any, AwsError, PortfolioDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getDescription: ZIO[Any, AwsError, PortfolioDescription] =
      AwsError.unwrapOptionField("description", description)
    def getProviderName: ZIO[Any, AwsError, ProviderName] =
      AwsError.unwrapOptionField("providerName", providerName)
    def getAddTags
        : ZIO[Any, AwsError, List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("addTags", addTags)
    def getRemoveTags: ZIO[Any, AwsError, List[TagKey]] =
      AwsError.unwrapOptionField("removeTags", removeTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioRequest
  ) extends zio.aws.servicecatalog.model.UpdatePortfolioRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val id: Id = zio.aws.servicecatalog.model.primitives.Id(impl.id())
    override val displayName: Option[PortfolioDisplayName] = scala
      .Option(impl.displayName())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.PortfolioDisplayName(value)
      )
    override val description: Option[PortfolioDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.PortfolioDescription(value)
      )
    override val providerName: Option[ProviderName] = scala
      .Option(impl.providerName())
      .map(value => zio.aws.servicecatalog.model.primitives.ProviderName(value))
    override val addTags
        : Option[List[zio.aws.servicecatalog.model.Tag.ReadOnly]] = scala
      .Option(impl.addTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.Tag.wrap(item)
        }.toList
      )
    override val removeTags: Option[List[TagKey]] = scala
      .Option(impl.removeTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.primitives.TagKey(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioRequest
  ): zio.aws.servicecatalog.model.UpdatePortfolioRequest.ReadOnly = new Wrapper(
    impl
  )
}
