package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait StackInstanceStatus {
  def unwrap
      : software.amazon.awssdk.services.servicecatalog.model.StackInstanceStatus
}
object StackInstanceStatus {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.StackInstanceStatus
  ): zio.aws.servicecatalog.model.StackInstanceStatus = value match {
    case software.amazon.awssdk.services.servicecatalog.model.StackInstanceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicecatalog.model.StackInstanceStatus.CURRENT =>
      val r = CURRENT
      r
    case software.amazon.awssdk.services.servicecatalog.model.StackInstanceStatus.OUTDATED =>
      val r = OUTDATED
      r
    case software.amazon.awssdk.services.servicecatalog.model.StackInstanceStatus.INOPERABLE =>
      val r = INOPERABLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicecatalog.model.StackInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.StackInstanceStatus =
      software.amazon.awssdk.services.servicecatalog.model.StackInstanceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CURRENT extends zio.aws.servicecatalog.model.StackInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.StackInstanceStatus =
      software.amazon.awssdk.services.servicecatalog.model.StackInstanceStatus.CURRENT
  }
  case object OUTDATED
      extends zio.aws.servicecatalog.model.StackInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.StackInstanceStatus =
      software.amazon.awssdk.services.servicecatalog.model.StackInstanceStatus.OUTDATED
  }
  case object INOPERABLE
      extends zio.aws.servicecatalog.model.StackInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.StackInstanceStatus =
      software.amazon.awssdk.services.servicecatalog.model.StackInstanceStatus.INOPERABLE
  }
}
