package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait ServiceActionDefinitionKey {
  def unwrap: software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionKey
}
object ServiceActionDefinitionKey {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionKey
  ): zio.aws.servicecatalog.model.ServiceActionDefinitionKey = value match {
    case software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionKey.NAME =>
      val r = Name
      r
    case software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionKey.VERSION =>
      val r = Version
      r
    case software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionKey.ASSUME_ROLE =>
      val r = AssumeRole
      r
    case software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionKey.PARAMETERS =>
      val r = Parameters
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicecatalog.model.ServiceActionDefinitionKey {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionKey =
      software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionKey.UNKNOWN_TO_SDK_VERSION
  }
  case object Name
      extends zio.aws.servicecatalog.model.ServiceActionDefinitionKey {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionKey =
      software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionKey.NAME
  }
  case object Version
      extends zio.aws.servicecatalog.model.ServiceActionDefinitionKey {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionKey =
      software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionKey.VERSION
  }
  case object AssumeRole
      extends zio.aws.servicecatalog.model.ServiceActionDefinitionKey {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionKey =
      software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionKey.ASSUME_ROLE
  }
  case object Parameters
      extends zio.aws.servicecatalog.model.ServiceActionDefinitionKey {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionKey =
      software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionKey.PARAMETERS
  }
}
