package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{ErrorDescription, ErrorCode}
import scala.jdk.CollectionConverters._
final case class RecordError(
    code: Option[ErrorCode] = None,
    description: Option[ErrorDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.RecordError = {
    import RecordError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.RecordError
      .builder()
      .optionallyWith(
        code.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.code)
      .optionallyWith(
        description.map(value =>
          ErrorDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.RecordError.ReadOnly =
    zio.aws.servicecatalog.model.RecordError.wrap(buildAwsValue())
}
object RecordError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.RecordError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.RecordError =
      zio.aws.servicecatalog.model
        .RecordError(code.map(value => value), description.map(value => value))
    def code: Option[ErrorCode]
    def description: Option[ErrorDescription]
    def getCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("code", code)
    def getDescription: ZIO[Any, AwsError, ErrorDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.RecordError
  ) extends zio.aws.servicecatalog.model.RecordError.ReadOnly {
    override val code: Option[ErrorCode] = scala
      .Option(impl.code())
      .map(value => zio.aws.servicecatalog.model.primitives.ErrorCode(value))
    override val description: Option[ErrorDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ErrorDescription(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.RecordError
  ): zio.aws.servicecatalog.model.RecordError.ReadOnly = new Wrapper(impl)
}
