package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{ParameterValue, ParameterKey}
import scala.jdk.CollectionConverters._
final case class ProvisioningParameter(
    key: Option[ParameterKey] = None,
    value: Option[ParameterValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ProvisioningParameter = {
    import ProvisioningParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ProvisioningParameter
      .builder()
      .optionallyWith(
        key.map(value => ParameterKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        value.map(value => ParameterValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.ProvisioningParameter.ReadOnly =
    zio.aws.servicecatalog.model.ProvisioningParameter.wrap(buildAwsValue())
}
object ProvisioningParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ProvisioningParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ProvisioningParameter =
      zio.aws.servicecatalog.model.ProvisioningParameter(
        key.map(value => value),
        value.map(value => value)
      )
    def key: Option[ParameterKey]
    def value: Option[ParameterValue]
    def getKey: ZIO[Any, AwsError, ParameterKey] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, ParameterValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisioningParameter
  ) extends zio.aws.servicecatalog.model.ProvisioningParameter.ReadOnly {
    override val key: Option[ParameterKey] = scala
      .Option(impl.key())
      .map(value => zio.aws.servicecatalog.model.primitives.ParameterKey(value))
    override val value: Option[ParameterValue] = scala
      .Option(impl.value())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ParameterValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisioningParameter
  ): zio.aws.servicecatalog.model.ProvisioningParameter.ReadOnly = new Wrapper(
    impl
  )
}
