package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.servicecatalog.model.primitives.{
  ProvisioningArtifactName,
  ProvisioningArtifactInfoValue,
  ProvisioningArtifactInfoKey,
  ProvisioningArtifactDescription,
  ProvisioningArtifactCreatedTime,
  Id
}
import scala.jdk.CollectionConverters._
final case class ProvisioningArtifactSummary(
    id: Option[Id] = None,
    name: Option[ProvisioningArtifactName] = None,
    description: Option[ProvisioningArtifactDescription] = None,
    createdTime: Option[ProvisioningArtifactCreatedTime] = None,
    provisioningArtifactMetadata: Option[
      Map[ProvisioningArtifactInfoKey, ProvisioningArtifactInfoValue]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactSummary = {
    import ProvisioningArtifactSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactSummary
      .builder()
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(
        name.map(value =>
          ProvisioningArtifactName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ProvisioningArtifactDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        createdTime.map(value =>
          ProvisioningArtifactCreatedTime.unwrap(value): Instant
        )
      )(_.createdTime)
      .optionallyWith(
        provisioningArtifactMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (ProvisioningArtifactInfoKey.unwrap(
                key
              ): java.lang.String) -> (ProvisioningArtifactInfoValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.provisioningArtifactMetadata)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ProvisioningArtifactSummary.ReadOnly =
    zio.aws.servicecatalog.model.ProvisioningArtifactSummary
      .wrap(buildAwsValue())
}
object ProvisioningArtifactSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ProvisioningArtifactSummary =
      zio.aws.servicecatalog.model.ProvisioningArtifactSummary(
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        createdTime.map(value => value),
        provisioningArtifactMetadata.map(value => value)
      )
    def id: Option[Id]
    def name: Option[ProvisioningArtifactName]
    def description: Option[ProvisioningArtifactDescription]
    def createdTime: Option[ProvisioningArtifactCreatedTime]
    def provisioningArtifactMetadata: Option[
      Map[ProvisioningArtifactInfoKey, ProvisioningArtifactInfoValue]
    ]
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ProvisioningArtifactName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ProvisioningArtifactDescription] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedTime: ZIO[Any, AwsError, ProvisioningArtifactCreatedTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getProvisioningArtifactMetadata: ZIO[Any, AwsError, Map[
      ProvisioningArtifactInfoKey,
      ProvisioningArtifactInfoValue
    ]] = AwsError.unwrapOptionField(
      "provisioningArtifactMetadata",
      provisioningArtifactMetadata
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactSummary
  ) extends zio.aws.servicecatalog.model.ProvisioningArtifactSummary.ReadOnly {
    override val id: Option[Id] = scala
      .Option(impl.id())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val name: Option[ProvisioningArtifactName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProvisioningArtifactName(value)
      )
    override val description: Option[ProvisioningArtifactDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.servicecatalog.model.primitives
          .ProvisioningArtifactDescription(value)
      )
    override val createdTime: Option[ProvisioningArtifactCreatedTime] = scala
      .Option(impl.createdTime())
      .map(value =>
        zio.aws.servicecatalog.model.primitives
          .ProvisioningArtifactCreatedTime(value)
      )
    override val provisioningArtifactMetadata: Option[
      Map[ProvisioningArtifactInfoKey, ProvisioningArtifactInfoValue]
    ] = scala
      .Option(impl.provisioningArtifactMetadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.servicecatalog.model.primitives.ProvisioningArtifactInfoKey(
              key
            ) -> zio.aws.servicecatalog.model.primitives
              .ProvisioningArtifactInfoValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactSummary
  ): zio.aws.servicecatalog.model.ProvisioningArtifactSummary.ReadOnly =
    new Wrapper(impl)
}
