package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  ProvisionedProductName,
  Id,
  ProvisionedProductPlanName
}
import scala.jdk.CollectionConverters._
final case class ProvisionedProductPlanSummary(
    planName: Option[ProvisionedProductPlanName] = None,
    planId: Option[Id] = None,
    provisionProductId: Option[Id] = None,
    provisionProductName: Option[ProvisionedProductName] = None,
    planType: Option[zio.aws.servicecatalog.model.ProvisionedProductPlanType] =
      None,
    provisioningArtifactId: Option[Id] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanSummary = {
    import ProvisionedProductPlanSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanSummary
      .builder()
      .optionallyWith(
        planName.map(value =>
          ProvisionedProductPlanName.unwrap(value): java.lang.String
        )
      )(_.planName)
      .optionallyWith(planId.map(value => Id.unwrap(value): java.lang.String))(
        _.planId
      )
      .optionallyWith(
        provisionProductId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisionProductId)
      .optionallyWith(
        provisionProductName.map(value =>
          ProvisionedProductName.unwrap(value): java.lang.String
        )
      )(_.provisionProductName)
      .optionallyWith(planType.map(value => value.unwrap))(_.planType)
      .optionallyWith(
        provisioningArtifactId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisioningArtifactId)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ProvisionedProductPlanSummary.ReadOnly =
    zio.aws.servicecatalog.model.ProvisionedProductPlanSummary
      .wrap(buildAwsValue())
}
object ProvisionedProductPlanSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ProvisionedProductPlanSummary =
      zio.aws.servicecatalog.model.ProvisionedProductPlanSummary(
        planName.map(value => value),
        planId.map(value => value),
        provisionProductId.map(value => value),
        provisionProductName.map(value => value),
        planType.map(value => value),
        provisioningArtifactId.map(value => value)
      )
    def planName: Option[ProvisionedProductPlanName]
    def planId: Option[Id]
    def provisionProductId: Option[Id]
    def provisionProductName: Option[ProvisionedProductName]
    def planType
        : Option[zio.aws.servicecatalog.model.ProvisionedProductPlanType]
    def provisioningArtifactId: Option[Id]
    def getPlanName: ZIO[Any, AwsError, ProvisionedProductPlanName] =
      AwsError.unwrapOptionField("planName", planName)
    def getPlanId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("planId", planId)
    def getProvisionProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("provisionProductId", provisionProductId)
    def getProvisionProductName: ZIO[Any, AwsError, ProvisionedProductName] =
      AwsError.unwrapOptionField("provisionProductName", provisionProductName)
    def getPlanType: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProvisionedProductPlanType
    ] = AwsError.unwrapOptionField("planType", planType)
    def getProvisioningArtifactId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("provisioningArtifactId", provisioningArtifactId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanSummary
  ) extends zio.aws.servicecatalog.model.ProvisionedProductPlanSummary.ReadOnly {
    override val planName: Option[ProvisionedProductPlanName] = scala
      .Option(impl.planName())
      .map(value =>
        zio.aws.servicecatalog.model.primitives
          .ProvisionedProductPlanName(value)
      )
    override val planId: Option[Id] = scala
      .Option(impl.planId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val provisionProductId: Option[Id] = scala
      .Option(impl.provisionProductId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val provisionProductName: Option[ProvisionedProductName] = scala
      .Option(impl.provisionProductName())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProvisionedProductName(value)
      )
    override val planType
        : Option[zio.aws.servicecatalog.model.ProvisionedProductPlanType] =
      scala
        .Option(impl.planType())
        .map(value =>
          zio.aws.servicecatalog.model.ProvisionedProductPlanType.wrap(value)
        )
    override val provisioningArtifactId: Option[Id] = scala
      .Option(impl.provisioningArtifactId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanSummary
  ): zio.aws.servicecatalog.model.ProvisionedProductPlanSummary.ReadOnly =
    new Wrapper(impl)
}
