package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.servicecatalog.model.primitives.{
  UserArn,
  ProvisioningArtifactName,
  PhysicalId,
  ProvisionedProductType,
  ProductViewName,
  UserArnSession,
  IdempotencyToken,
  ProvisionedProductNameOrArn,
  CreatedTime,
  ProvisionedProductStatusMessage,
  Id
}
import scala.jdk.CollectionConverters._
final case class ProvisionedProductAttribute(
    name: Option[ProvisionedProductNameOrArn] = None,
    arn: Option[ProvisionedProductNameOrArn] = None,
    `type`: Option[ProvisionedProductType] = None,
    id: Option[Id] = None,
    status: Option[zio.aws.servicecatalog.model.ProvisionedProductStatus] =
      None,
    statusMessage: Option[ProvisionedProductStatusMessage] = None,
    createdTime: Option[CreatedTime] = None,
    idempotencyToken: Option[IdempotencyToken] = None,
    lastRecordId: Option[Id] = None,
    lastProvisioningRecordId: Option[Id] = None,
    lastSuccessfulProvisioningRecordId: Option[Id] = None,
    tags: Option[Iterable[zio.aws.servicecatalog.model.Tag]] = None,
    physicalId: Option[PhysicalId] = None,
    productId: Option[Id] = None,
    productName: Option[ProductViewName] = None,
    provisioningArtifactId: Option[Id] = None,
    provisioningArtifactName: Option[ProvisioningArtifactName] = None,
    userArn: Option[UserArn] = None,
    userArnSession: Option[UserArnSession] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductAttribute = {
    import ProvisionedProductAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductAttribute
      .builder()
      .optionallyWith(
        name.map(value =>
          ProvisionedProductNameOrArn.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        arn.map(value =>
          ProvisionedProductNameOrArn.unwrap(value): java.lang.String
        )
      )(_.arn)
      .optionallyWith(
        `type`.map(value =>
          ProvisionedProductType.unwrap(value): java.lang.String
        )
      )(_.`type`)
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          ProvisionedProductStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        createdTime.map(value => CreatedTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        idempotencyToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.idempotencyToken)
      .optionallyWith(
        lastRecordId.map(value => Id.unwrap(value): java.lang.String)
      )(_.lastRecordId)
      .optionallyWith(
        lastProvisioningRecordId.map(value =>
          Id.unwrap(value): java.lang.String
        )
      )(_.lastProvisioningRecordId)
      .optionallyWith(
        lastSuccessfulProvisioningRecordId.map(value =>
          Id.unwrap(value): java.lang.String
        )
      )(_.lastSuccessfulProvisioningRecordId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        physicalId.map(value => PhysicalId.unwrap(value): java.lang.String)
      )(_.physicalId)
      .optionallyWith(
        productId.map(value => Id.unwrap(value): java.lang.String)
      )(_.productId)
      .optionallyWith(
        productName.map(value =>
          ProductViewName.unwrap(value): java.lang.String
        )
      )(_.productName)
      .optionallyWith(
        provisioningArtifactId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisioningArtifactId)
      .optionallyWith(
        provisioningArtifactName.map(value =>
          ProvisioningArtifactName.unwrap(value): java.lang.String
        )
      )(_.provisioningArtifactName)
      .optionallyWith(
        userArn.map(value => UserArn.unwrap(value): java.lang.String)
      )(_.userArn)
      .optionallyWith(
        userArnSession.map(value =>
          UserArnSession.unwrap(value): java.lang.String
        )
      )(_.userArnSession)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ProvisionedProductAttribute.ReadOnly =
    zio.aws.servicecatalog.model.ProvisionedProductAttribute
      .wrap(buildAwsValue())
}
object ProvisionedProductAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ProvisionedProductAttribute =
      zio.aws.servicecatalog.model.ProvisionedProductAttribute(
        name.map(value => value),
        arn.map(value => value),
        `type`.map(value => value),
        id.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        createdTime.map(value => value),
        idempotencyToken.map(value => value),
        lastRecordId.map(value => value),
        lastProvisioningRecordId.map(value => value),
        lastSuccessfulProvisioningRecordId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        physicalId.map(value => value),
        productId.map(value => value),
        productName.map(value => value),
        provisioningArtifactId.map(value => value),
        provisioningArtifactName.map(value => value),
        userArn.map(value => value),
        userArnSession.map(value => value)
      )
    def name: Option[ProvisionedProductNameOrArn]
    def arn: Option[ProvisionedProductNameOrArn]
    def `type`: Option[ProvisionedProductType]
    def id: Option[Id]
    def status: Option[zio.aws.servicecatalog.model.ProvisionedProductStatus]
    def statusMessage: Option[ProvisionedProductStatusMessage]
    def createdTime: Option[CreatedTime]
    def idempotencyToken: Option[IdempotencyToken]
    def lastRecordId: Option[Id]
    def lastProvisioningRecordId: Option[Id]
    def lastSuccessfulProvisioningRecordId: Option[Id]
    def tags: Option[List[zio.aws.servicecatalog.model.Tag.ReadOnly]]
    def physicalId: Option[PhysicalId]
    def productId: Option[Id]
    def productName: Option[ProductViewName]
    def provisioningArtifactId: Option[Id]
    def provisioningArtifactName: Option[ProvisioningArtifactName]
    def userArn: Option[UserArn]
    def userArnSession: Option[UserArnSession]
    def getName: ZIO[Any, AwsError, ProvisionedProductNameOrArn] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, ProvisionedProductNameOrArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getType: ZIO[Any, AwsError, ProvisionedProductType] =
      AwsError.unwrapOptionField("type", `type`)
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProvisionedProductStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, ProvisionedProductStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getCreatedTime: ZIO[Any, AwsError, CreatedTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getIdempotencyToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("idempotencyToken", idempotencyToken)
    def getLastRecordId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("lastRecordId", lastRecordId)
    def getLastProvisioningRecordId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("lastProvisioningRecordId", lastProvisioningRecordId)
    def getLastSuccessfulProvisioningRecordId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField(
        "lastSuccessfulProvisioningRecordId",
        lastSuccessfulProvisioningRecordId
      )
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPhysicalId: ZIO[Any, AwsError, PhysicalId] =
      AwsError.unwrapOptionField("physicalId", physicalId)
    def getProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("productId", productId)
    def getProductName: ZIO[Any, AwsError, ProductViewName] =
      AwsError.unwrapOptionField("productName", productName)
    def getProvisioningArtifactId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("provisioningArtifactId", provisioningArtifactId)
    def getProvisioningArtifactName
        : ZIO[Any, AwsError, ProvisioningArtifactName] = AwsError
      .unwrapOptionField("provisioningArtifactName", provisioningArtifactName)
    def getUserArn: ZIO[Any, AwsError, UserArn] =
      AwsError.unwrapOptionField("userArn", userArn)
    def getUserArnSession: ZIO[Any, AwsError, UserArnSession] =
      AwsError.unwrapOptionField("userArnSession", userArnSession)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductAttribute
  ) extends zio.aws.servicecatalog.model.ProvisionedProductAttribute.ReadOnly {
    override val name: Option[ProvisionedProductNameOrArn] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.servicecatalog.model.primitives
          .ProvisionedProductNameOrArn(value)
      )
    override val arn: Option[ProvisionedProductNameOrArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.servicecatalog.model.primitives
          .ProvisionedProductNameOrArn(value)
      )
    override val `type`: Option[ProvisionedProductType] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProvisionedProductType(value)
      )
    override val id: Option[Id] = scala
      .Option(impl.id())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val status
        : Option[zio.aws.servicecatalog.model.ProvisionedProductStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.servicecatalog.model.ProvisionedProductStatus.wrap(value)
      )
    override val statusMessage: Option[ProvisionedProductStatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives
          .ProvisionedProductStatusMessage(value)
      )
    override val createdTime: Option[CreatedTime] = scala
      .Option(impl.createdTime())
      .map(value => zio.aws.servicecatalog.model.primitives.CreatedTime(value))
    override val idempotencyToken: Option[IdempotencyToken] = scala
      .Option(impl.idempotencyToken())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.IdempotencyToken(value)
      )
    override val lastRecordId: Option[Id] = scala
      .Option(impl.lastRecordId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val lastProvisioningRecordId: Option[Id] = scala
      .Option(impl.lastProvisioningRecordId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val lastSuccessfulProvisioningRecordId: Option[Id] = scala
      .Option(impl.lastSuccessfulProvisioningRecordId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val tags: Option[List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.Tag.wrap(item)
          }.toList
        )
    override val physicalId: Option[PhysicalId] = scala
      .Option(impl.physicalId())
      .map(value => zio.aws.servicecatalog.model.primitives.PhysicalId(value))
    override val productId: Option[Id] = scala
      .Option(impl.productId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val productName: Option[ProductViewName] = scala
      .Option(impl.productName())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProductViewName(value)
      )
    override val provisioningArtifactId: Option[Id] = scala
      .Option(impl.provisioningArtifactId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val provisioningArtifactName: Option[ProvisioningArtifactName] =
      scala
        .Option(impl.provisioningArtifactName())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisioningArtifactName(value)
        )
    override val userArn: Option[UserArn] = scala
      .Option(impl.userArn())
      .map(value => zio.aws.servicecatalog.model.primitives.UserArn(value))
    override val userArnSession: Option[UserArnSession] = scala
      .Option(impl.userArnSession())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.UserArnSession(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductAttribute
  ): zio.aws.servicecatalog.model.ProvisionedProductAttribute.ReadOnly =
    new Wrapper(impl)
}
