package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.servicecatalog.model.primitives.{CreatedTime, ResourceARN}
import scala.jdk.CollectionConverters._
final case class ProductViewDetail(
    productViewSummary: Option[
      zio.aws.servicecatalog.model.ProductViewSummary
    ] = None,
    status: Option[zio.aws.servicecatalog.model.Status] = None,
    productARN: Option[ResourceARN] = None,
    createdTime: Option[CreatedTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ProductViewDetail = {
    import ProductViewDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ProductViewDetail
      .builder()
      .optionallyWith(productViewSummary.map(value => value.buildAwsValue()))(
        _.productViewSummary
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        productARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.productARN)
      .optionallyWith(
        createdTime.map(value => CreatedTime.unwrap(value): Instant)
      )(_.createdTime)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.ProductViewDetail.ReadOnly =
    zio.aws.servicecatalog.model.ProductViewDetail.wrap(buildAwsValue())
}
object ProductViewDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ProductViewDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ProductViewDetail =
      zio.aws.servicecatalog.model.ProductViewDetail(
        productViewSummary.map(value => value.asEditable),
        status.map(value => value),
        productARN.map(value => value),
        createdTime.map(value => value)
      )
    def productViewSummary
        : Option[zio.aws.servicecatalog.model.ProductViewSummary.ReadOnly]
    def status: Option[zio.aws.servicecatalog.model.Status]
    def productARN: Option[ResourceARN]
    def createdTime: Option[CreatedTime]
    def getProductViewSummary: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProductViewSummary.ReadOnly
    ] = AwsError.unwrapOptionField("productViewSummary", productViewSummary)
    def getStatus: ZIO[Any, AwsError, zio.aws.servicecatalog.model.Status] =
      AwsError.unwrapOptionField("status", status)
    def getProductARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("productARN", productARN)
    def getCreatedTime: ZIO[Any, AwsError, CreatedTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProductViewDetail
  ) extends zio.aws.servicecatalog.model.ProductViewDetail.ReadOnly {
    override val productViewSummary
        : Option[zio.aws.servicecatalog.model.ProductViewSummary.ReadOnly] =
      scala
        .Option(impl.productViewSummary())
        .map(value =>
          zio.aws.servicecatalog.model.ProductViewSummary.wrap(value)
        )
    override val status: Option[zio.aws.servicecatalog.model.Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.servicecatalog.model.Status.wrap(value))
    override val productARN: Option[ResourceARN] = scala
      .Option(impl.productARN())
      .map(value => zio.aws.servicecatalog.model.primitives.ResourceARN(value))
    override val createdTime: Option[CreatedTime] = scala
      .Option(impl.createdTime())
      .map(value => zio.aws.servicecatalog.model.primitives.CreatedTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProductViewDetail
  ): zio.aws.servicecatalog.model.ProductViewDetail.ReadOnly = new Wrapper(impl)
}
