package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.PrincipalARN
import scala.jdk.CollectionConverters._
final case class Principal(
    principalARN: Option[PrincipalARN] = None,
    principalType: Option[zio.aws.servicecatalog.model.PrincipalType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.Principal = {
    import Principal.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.Principal
      .builder()
      .optionallyWith(
        principalARN.map(value => PrincipalARN.unwrap(value): java.lang.String)
      )(_.principalARN)
      .optionallyWith(principalType.map(value => value.unwrap))(_.principalType)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.Principal.ReadOnly =
    zio.aws.servicecatalog.model.Principal.wrap(buildAwsValue())
}
object Principal {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.Principal
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.Principal =
      zio.aws.servicecatalog.model.Principal(
        principalARN.map(value => value),
        principalType.map(value => value)
      )
    def principalARN: Option[PrincipalARN]
    def principalType: Option[zio.aws.servicecatalog.model.PrincipalType]
    def getPrincipalARN: ZIO[Any, AwsError, PrincipalARN] =
      AwsError.unwrapOptionField("principalARN", principalARN)
    def getPrincipalType
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.PrincipalType] =
      AwsError.unwrapOptionField("principalType", principalType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.Principal
  ) extends zio.aws.servicecatalog.model.Principal.ReadOnly {
    override val principalARN: Option[PrincipalARN] = scala
      .Option(impl.principalARN())
      .map(value => zio.aws.servicecatalog.model.primitives.PrincipalARN(value))
    override val principalType
        : Option[zio.aws.servicecatalog.model.PrincipalType] = scala
      .Option(impl.principalType())
      .map(value => zio.aws.servicecatalog.model.PrincipalType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.Principal
  ): zio.aws.servicecatalog.model.Principal.ReadOnly = new Wrapper(impl)
}
