package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.OrganizationNodeValue
import scala.jdk.CollectionConverters._
final case class OrganizationNode(
    `type`: Option[zio.aws.servicecatalog.model.OrganizationNodeType] = None,
    value: Option[OrganizationNodeValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.OrganizationNode = {
    import OrganizationNode.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.OrganizationNode
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        value.map(value =>
          OrganizationNodeValue.unwrap(value): java.lang.String
        )
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.OrganizationNode.ReadOnly =
    zio.aws.servicecatalog.model.OrganizationNode.wrap(buildAwsValue())
}
object OrganizationNode {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.OrganizationNode
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.OrganizationNode =
      zio.aws.servicecatalog.model
        .OrganizationNode(`type`.map(value => value), value.map(value => value))
    def `type`: Option[zio.aws.servicecatalog.model.OrganizationNodeType]
    def value: Option[OrganizationNodeValue]
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.OrganizationNodeType
    ] = AwsError.unwrapOptionField("type", `type`)
    def getValue: ZIO[Any, AwsError, OrganizationNodeValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.OrganizationNode
  ) extends zio.aws.servicecatalog.model.OrganizationNode.ReadOnly {
    override val `type`
        : Option[zio.aws.servicecatalog.model.OrganizationNodeType] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.servicecatalog.model.OrganizationNodeType.wrap(value)
      )
    override val value: Option[OrganizationNodeValue] = scala
      .Option(impl.value())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.OrganizationNodeValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.OrganizationNode
  ): zio.aws.servicecatalog.model.OrganizationNode.ReadOnly = new Wrapper(impl)
}
