package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  TagOptionActive,
  TagOptionValue,
  TagOptionKey
}
import scala.jdk.CollectionConverters._
final case class ListTagOptionsFilters(
    key: Option[TagOptionKey] = None,
    value: Option[TagOptionValue] = None,
    active: Option[TagOptionActive] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsFilters = {
    import ListTagOptionsFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsFilters
      .builder()
      .optionallyWith(
        key.map(value => TagOptionKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        value.map(value => TagOptionValue.unwrap(value): java.lang.String)
      )(_.value)
      .optionallyWith(
        active.map(value => TagOptionActive.unwrap(value): java.lang.Boolean)
      )(_.active)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.ListTagOptionsFilters.ReadOnly =
    zio.aws.servicecatalog.model.ListTagOptionsFilters.wrap(buildAwsValue())
}
object ListTagOptionsFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ListTagOptionsFilters =
      zio.aws.servicecatalog.model.ListTagOptionsFilters(
        key.map(value => value),
        value.map(value => value),
        active.map(value => value)
      )
    def key: Option[TagOptionKey]
    def value: Option[TagOptionValue]
    def active: Option[TagOptionActive]
    def getKey: ZIO[Any, AwsError, TagOptionKey] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, TagOptionValue] =
      AwsError.unwrapOptionField("value", value)
    def getActive: ZIO[Any, AwsError, TagOptionActive] =
      AwsError.unwrapOptionField("active", active)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsFilters
  ) extends zio.aws.servicecatalog.model.ListTagOptionsFilters.ReadOnly {
    override val key: Option[TagOptionKey] = scala
      .Option(impl.key())
      .map(value => zio.aws.servicecatalog.model.primitives.TagOptionKey(value))
    override val value: Option[TagOptionValue] = scala
      .Option(impl.value())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.TagOptionValue(value)
      )
    override val active: Option[TagOptionActive] = scala
      .Option(impl.active())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.TagOptionActive(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsFilters
  ): zio.aws.servicecatalog.model.ListTagOptionsFilters.ReadOnly = new Wrapper(
    impl
  )
}
