package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{Id, AcceptLanguage}
import scala.jdk.CollectionConverters._
final case class ListProvisioningArtifactsRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    productId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsRequest = {
    import ListProvisioningArtifactsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .productId(Id.unwrap(productId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListProvisioningArtifactsRequest.ReadOnly =
    zio.aws.servicecatalog.model.ListProvisioningArtifactsRequest
      .wrap(buildAwsValue())
}
object ListProvisioningArtifactsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ListProvisioningArtifactsRequest =
      zio.aws.servicecatalog.model.ListProvisioningArtifactsRequest(
        acceptLanguage.map(value => value),
        productId
      )
    def acceptLanguage: Option[AcceptLanguage]
    def productId: Id
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getProductId: ZIO[Any, Nothing, Id] = ZIO.succeed(productId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsRequest
  ) extends zio.aws.servicecatalog.model.ListProvisioningArtifactsRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val productId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.productId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsRequest
  ): zio.aws.servicecatalog.model.ListProvisioningArtifactsRequest.ReadOnly =
    new Wrapper(impl)
}
